<?php
namespace Xtwo\CategoryInfoDetailApi\Model;

use Magento\Catalog\Api\CategoryRepositoryInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Xtwo\CategoryInfoDetailApi\Api\CategoryInformationInterface;
use Magento\Catalog\Model\CategoryFactory;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Cms\Model\Template\FilterProvider;
use Magento\Framework\App\RequestInterface;
use Xtwo\CustomApis\Helper\Data as CustomApisHelper;

class CategoryInformation implements CategoryInformationInterface
{
    /**
     * @var CategoryRepositoryInterface
     */
    protected $categoryRepository;
	private $categoryFactory;
	protected $storeManager;
	private $filterProvider;
    protected $helper;
    protected $searchCriteriaBuilder;
    protected $blockRepository;
    private $request;
    private $customApisHelper;

    /**
     * CategoryInformation constructor.
     *
     * @param CategoryRepositoryInterface $categoryRepository
     */
    public function __construct(
        CategoryRepositoryInterface $categoryRepository,
		StoreManagerInterface $storeManager,
		\Magento\Framework\Api\SearchCriteriaBuilder $searchCriteriaBuilder,
		\Magento\Cms\Api\BlockRepositoryInterface $blockRepository,
		CategoryFactory $categoryFactory,
		FilterProvider $filterProvider,
        \Xtwo\ProductDetailApi\Helper\Data $helper,
        RequestInterface $request,
        CustomApisHelper $customApisHelper
    ) {
        $this->categoryRepository = $categoryRepository;
		$this->categoryFactory = $categoryFactory;
		$this->searchCriteriaBuilder = $searchCriteriaBuilder;
		$this->blockRepository = $blockRepository;
		$this->storeManager = $storeManager;
		$this->filterProvider = $filterProvider;
        $this->helper = $helper;
        $this->request = $request;
        $this->customApisHelper = $customApisHelper;
    }

    /**
     * {@inheritdoc}
     */
    public function getCategoryInfo($urlKey)
    {
        $subCategoryUrl1 = $this->request->getParam('subCategoryUrl1');
        $subCategoryUrl2 = $this->request->getParam('subCategoryUrl2');
		$rootPath = $this->storeManager->getStore()->getBaseUrl();
        $storeId = $this->storeManager->getStore()->getId();
        $categoryIds = $this->customApisHelper->getCategoryLevels($urlKey,$subCategoryUrl1,$subCategoryUrl2,$storeId);
        $data = $this->categoryFactory->create()->loadByAttribute('entity_id', $categoryIds[0]);
        $categoryBreadCrumb = $this->helper->getCategoryBreadcrumb($categoryIds);
        if (!empty($categoryBreadCrumb)) {
            $categoryBreadCrumb[0]['label'] = 'Home';
            $categoryBreadCrumb[0]['title'] = 'Home';
        }
        $descriptionTop = $data->getDescriptionTop();
        if(empty($descriptionTop)){$data['description_top'] = ""; }else {
        $replaceTextTop = $this->filterProvider->getPageFilter()->filter($descriptionTop);
        $description = $data['description_top'] = $replaceTextTop;
		
		$findTextOne = $rootPath;     
		$replaceTextOne = "";
		$InitialDescTopForRootpathTop =  str_replace($findTextOne, $replaceTextOne, $replaceTextTop);
		
		$findTextTop = ".html";     
		$replacingTextTop = "";
		$InitialDescTop =  str_replace($findTextTop, $replacingTextTop, $InitialDescTopForRootpathTop);
		
		$findTextForLinkTop = "href=\"";     
		$replaceTextForLinkTop = "href=\"/category";
		$finalDescTop =  str_replace($findTextForLinkTop, $replaceTextForLinkTop, $InitialDescTop);
		
		//replace for image
		$findTextForLinkTop1 = "src=\"/media/";     
		$replaceTextForLinkTop1 = 'src="https://cdn.xtwostore.com/media/';
		$finalDescTop1 =  str_replace($findTextForLinkTop1, $replaceTextForLinkTop1, $finalDescTop);
			
		//
		
		$description = $data['description_top'] = $finalDescTop1;
        }
        $descriptionBottom = $data->getDescriptionBottom();
        if(empty($descriptionBottom)){$data['description_bottom'] = ""; }else {
        $replaceTextBottom = $this->filterProvider->getPageFilter()->filter($descriptionBottom);
        $data['description_bottom'] = $replaceTextBottom;
		
		$findTextTwo = $rootPath;     
		$replaceTextTwo = "";
		$InitialDescTopForRootpathBottom =  str_replace($findTextTwo, $replaceTextTwo, $replaceTextBottom);
		
		$findTextBottom = ".html";      
		$replacingTextBottom = "";
		$InitialDescBottom =  str_replace($findTextBottom, $replacingTextBottom, $InitialDescTopForRootpathBottom);
		
		$findTextForLinkBottom = "href=\"";      
		$replaceTextForLinkBottom = "href=\"/category";
		$finalDescBottom =  str_replace($findTextForLinkBottom, $replaceTextForLinkBottom, $InitialDescBottom);
		
		//replace for image
		$findTextForLinkBottom1 = "src=\"/media/";     
		$replaceTextForLinkBottom1 = 'src="https://cdn.xtwostore.com/media/';
		$finalDescBottom1 =  str_replace($findTextForLinkBottom1, $replaceTextForLinkBottom1, $finalDescBottom);
			
		//
		
		$data['description_bottom'] = $finalDescBottom1;
        }
        $descriptionLeft = $data->getDescriptionLeft();
        if(empty($descriptionLeft)){$data['description_left'] = ""; }else {
        $replaceTextLeft = $this->filterProvider->getPageFilter()->filter($descriptionLeft);
        $data['description_left'] = $replaceTextLeft;
		
		$findTextThree = $rootPath;       
		$replaceTextThree = "";
		$InitialDescTopForRootpathLeft =  str_replace($findTextThree, $replaceTextThree, $replaceTextLeft);
		
		$findTextLeft = ".html";        
		$replacingTextLeft = "";
		$InitialDescLeft =  str_replace($findTextLeft, $replacingTextLeft, $InitialDescTopForRootpathLeft);
		
		$findTextForLinkLeft = "href=\"";        
		$replaceTextForLinkLeft = "href=\"/category";
		$finalDescLeft =  str_replace($findTextForLinkLeft, $replaceTextForLinkLeft, $InitialDescLeft);
		
		//replace for image
		$findTextForLinkLeft1 = "src=\"/media/";     
		$replaceTextForLinkLeft1 = 'src="https://cdn.xtwostore.com/media/';
		$finalDescLeft1 =  str_replace($findTextForLinkLeft1, $replaceTextForLinkLeft1, $finalDescLeft);
			
		//
		
		$data['description_left'] = $finalDescLeft1;
        }

        if(!empty($data['landing_page'])){$identifier = $data['landing_page'];
        $staticBlock = $this->blockRepository->getById($data['landing_page']);
        $blockIdentifier = $staticBlock->getIdentifier();
        $data['landing_page'] = $blockIdentifier;
        }
            if(empty($description))
            {
                return $data;
            }
            else
            {
            if (stripos($description, "block_id") !== false) {

                function string_between_two_string($str, $starting_word, $ending_word)
                {
                    $subtring_start = strpos($str, $starting_word);
                    $subtring_start += strlen($starting_word);
                    $size = strpos($str, $ending_word, $subtring_start) - $subtring_start;
                    return substr($str, $subtring_start, $size);
                }

                $substring = string_between_two_string($description, 'block_id="', '"}}');
                $cmsStoreId = $this->storeManager->getStore()->getId();
                $this->searchCriteriaBuilder->addFilter('identifier', $substring ,'eq');
                $this->searchCriteriaBuilder->addFilter('is_active',1, 'eq');
                $this->searchCriteriaBuilder->addFilter('store_id', $cmsStoreId, 'eq');
                $searchCriteria = $this->searchCriteriaBuilder->create();

                $cmsBlock = $this->blockRepository->getList($searchCriteria)->getItems();

                $dataLiveCmsBlock =[];
                $ide = "";
                $contentreplace = "";
                $storeId = "";

                if ($cmsBlock && count($cmsBlock) > 0) {
                    foreach ($cmsBlock as $key=>$value) {
                        $ide = $dataLiveCmsBlock[$key]['identifier'] = $value->getIdentifier();
                        $contentreplace = $dataLiveCmsBlock[$key]['static_block_content'] = $value->getContent();
                        $storeId = $dataLiveCmsBlock[$key]['Store_id'] = $value->getStoreId();
                    }
                }
                $dataDescription = $description;
                $findText = "{{block class=\"Magento\\Cms\\Block\\Block\" block_id=\"$ide\"}}";
                $replaceText = $this->filterProvider->getPageFilter()->filter($contentreplace);
                $finalDesc =  str_replace($findText, $replaceText, $dataDescription);
                $data['description_top'] = $finalDesc;
                $data['created_at'] = $storeId;
                $data['children'] = $categoryBreadCrumb;
                return $data;
            }
		}
        $data['children'] = $categoryBreadCrumb;
		return $data;
    }
}