define([
    'jquery',
    'mage/utils/wrapper',
    'Xtwo_Catalog/js/ajax-product-update',
    'Magento_Catalog/js/price-utils'
], function ($, wrapper, ajaxProductUpdate, priceUtils) {
    'use strict';

    return function(targetModule){

        var reloadPrice = targetModule.prototype._reloadPrice;
        var reloadPriceWrapper = wrapper.wrap(reloadPrice, function(original){

            var defaultConfigurationId = $('input[name="selected_configurable_option"]').val();

            if (!this.simpleProduct && defaultConfigurationId !== undefined) {
                this.simpleProduct = defaultConfigurationId;
                this.options.values = this.options.spConfig.index[defaultConfigurationId];
            }

            var result = original();
            var simpleSku = this.options.spConfig.skus[this.simpleProduct];

            if (simpleSku != '') {
                $('div.product-info-main .sku .value').html(simpleSku);
            }
            var prices = this.options.spConfig.optionPrices[this.simpleProduct];

            $('span.price-msrp_price span.price-wrapper').html(priceUtils.formatPrice(prices.msrpPrice.amount));
            $('span.normal-price').html(priceUtils.formatPrice(prices.finalPrice.amount));

            var diff = prices.msrpPrice.amount - prices.finalPrice.amount;
            var diffPercent = diff * 100 / prices.msrpPrice.amount;
            $('span.save-price-msrp strong').html(Math.round(diffPercent) + '%');
            $('.percent-difference').html('(' + priceUtils.formatPrice(diff) + ')');

            ajaxProductUpdate.getSimpleInfo(this.simpleProduct, $("input[name=product]").val());
            return result;
        });

        targetModule.prototype._reloadPrice = reloadPriceWrapper;

        var initializeOptions = targetModule.prototype._initializeOptions;
        var initializeOptionsWrapper = wrapper.wrap(initializeOptions, function(original){
            var result = original();
            var defaultConfigurationId = $('input[name="selected_configurable_option"]').val();

            if (!this.simpleProduct && defaultConfigurationId !== undefined) {
                console.log(this.options.spConfig);

                this.simpleProduct = defaultConfigurationId;
                this.options.values = this.options.spConfig.index[defaultConfigurationId];
            }

            return result;
        });

        targetModule.prototype._initializeOptions = initializeOptionsWrapper;
        return targetModule;
    };


});
