define(['jquery', 'mage/url'], function ($, url) {
    'use strict';

    return {
        /**
         * Ajax Call
         *
         * @returns {void}
         * @private
         */
        getSimpleInfo: function (simpleProductId, configurableProductId = false) {
            url.setBaseUrl(BASE_URL);
            var ajaxLink = url.build('xtwo_catalog/product/attributes');

            $.ajax({
                dataType: "json",
                url: ajaxLink,
                type: "get",
                data: {
                    simpleProductId: simpleProductId,
                    configurableProductId: configurableProductId
                },
                showLoader: true,///@TODO to check loader
                success: function (result) {
                    if (result.error) {
                        return false;
                    }
                    $("#product_custom_attributes_tab").html(result.attributes_data);

                    let keyBlock;
                    for (keyBlock in result.relatedBlocks) {
                        var parsedResponse = $.parseHTML(result.relatedBlocks[keyBlock]);

                        let destination = $("div.items-" + keyBlock);

                        $(".products-" + keyBlock + " .owl-carousel").owlCarousel('destroy');
                        destination.hide();
                        $("div.block." + keyBlock + " div.title").hide();
                        if (parsedResponse[1] && parsedResponse[1].innerHTML.search('block-content') !== -1) {
                            destination.html(parsedResponse[1].innerHTML);
                            destination.show();
                            $(".products-" + keyBlock + " .owl-carousel").owlCarousel('refresh');
                        }
                    }
                    var pageurl = result.url;

                    if (pageurl != window.location) {
                        window.history.pushState({"url": pageurl }, "", pageurl);
                    }

                    var mainAttributes = result.main_attributes;
                    if (mainAttributes) {
                        $('product-main-attributes').html(mainAttributes);
                    }

                    var title = result.title;
                    if (title) {
                        $('h1.page-title span.base').html(title);
                        $('div.breadcrumbs li.product strong').html(title);
                    }
                    $('.layer-image-container').hide()
                    var layerImage = result.layer_image;
                    if (layerImage) {
                        $('layer-image').attr('src', layerImage);
                        $('.layer-image-container').show();
                    }

                }
                //@TODO to add error cases
            });
        }
    };
});
