<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Catalog\ViewModel\Product;

use Magento\Catalog\Helper\Data;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Escaper;
use Magento\Framework\Registry;
use Magento\Framework\Serialize\Serializer\JsonHexTag;
use Magento\Store\Model\ScopeInterface;

/**
 * Class Breadcrumbs - it had to be rewritten as plugin gave the following:
 *  Error: Undefined class constant 'XML_PATH_CATEGORY_URL_SUFFIX' in - magento core bug
 */
class Breadcrumbs extends \Magento\Catalog\ViewModel\Product\Breadcrumbs
{
    private const XML_PATH_CATEGORY_URL_SUFFIX = 'catalog/seo/category_url_suffix';
    private const XML_PATH_PRODUCT_USE_CATEGORIES = 'catalog/seo/product_use_categories';

    /**
     * @var \Magento\Framework\Registry
     */
    private Registry $registry;
    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    private ScopeConfigInterface $scopeConfig;

    /**
     * @param Data $catalogData
     * @param ScopeConfigInterface $scopeConfig
     * @param Escaper $escaper
     * @param JsonHexTag $jsonSerializer
     * @param \Magento\Framework\Registry $registry
     */
    public function __construct(
        Data $catalogData,
        ScopeConfigInterface $scopeConfig,
        Escaper $escaper,
        JsonHexTag $jsonSerializer,
        Registry $registry
    )
    {
        parent::__construct($catalogData, $scopeConfig, $escaper, $jsonSerializer);
        $this->registry = $registry;
        $this->scopeConfig = $scopeConfig;
    }

    /**
     * Returns category URL suffix.
     *
     * @return mixed
     */
    public function getCategoryUrlSuffix()
    {
        return $this->scopeConfig->getValue(
            static::XML_PATH_CATEGORY_URL_SUFFIX,
            ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * Checks if categories path is used for product URLs.
     *
     * @return bool
     */
    public function isCategoryUsedInProductUrl(): bool
    {
        return $this->scopeConfig->isSetFlag(
            static::XML_PATH_PRODUCT_USE_CATEGORIES,
            ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * Returns product name.
     *
     * @return string
     */
    public function getProductName(): string
    {
        $productName = $this->registry->registry('product_name');

        return !empty($productName) ? $productName : parent::getProductName();

    }
}
