<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Catalog\Plugin;

use Magento\Framework\Registry;
use Magento\Swatches\Block\Product\Renderer\Configurable;

class SwatchesBlockProductRendererConfigurablePlugin
{
    private Registry $registry;

    /**
     * SwatchesBlockProductRendererConfigurablePlugin constructor.
     *
     * @param \Magento\Framework\Registry $registry
     */
    public function __construct(Registry $registry)
    {

        $this->registry = $registry;
    }

    /**
     * @param \Magento\Swatches\Block\Product\Renderer\Configurable $subject
     * @param string $result
     *
     * @return false|string
     */
    public function afterGetJsonConfig(Configurable $subject, $result)
    {
        $jsonResult = json_decode($result, true);
        $jsonResult['skus'] = [];

        foreach ($subject->getAllowProducts() as $simpleProduct) {
            $jsonResult['skus'][$simpleProduct->getId()] = $simpleProduct->getSku();
        }

        $configProduct = $subject->getProduct();

        $configType = $configProduct->getTypeInstance();
        $attributes = $configType->getConfigurableAttributesAsArray($configProduct);

        $simpleProduct = $this->registry->registry('simple_product');

        if ($simpleProduct !== null && $simpleProduct->getId()) {
            $options = [];
            foreach ($attributes as $attribute) {
                $id = $attribute['attribute_id'];
                $value = $simpleProduct->getData($attribute['attribute_code']);
                $options[$id] = $value;
            }
            $jsonResult['defaultValues'] = $options;
        }

        $result = json_encode($jsonResult);

        return $result;
    }

    /**
     * Get cache key informative items.
     *
     * @param \Magento\Swatches\Block\Product\Renderer\Configurable $subject
     * @param array $result
     *
     * @return mixed
     */
    public function afterGetCacheKeyInfo(Configurable $subject, $result)
    {
        $simpleProduct = $this->registry->registry('simple_product');

        if (isset($simpleProduct) && $simpleProduct->getId()) {
            $result[] = $simpleProduct->getId();
        }

        return $result;
    }
}
