<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Catalog\Plugin;

use Magento\Catalog\Ui\Component\Listing\Columns\Price;
use Magento\Catalog\Ui\DataProvider\Product\Form\Modifier\Related as RelatedParent;
use Magento\Ui\Component\Form\Fieldset;

class RelatedPlugin extends RelatedParent
{
    const GROUP_RELATED = 'related';
    const DATA_SCOPE_SERIESSELL = 'seriessell';
    const DATA_SCOPE_ALTERNATIVESELL = 'alternativesell';
    const DATA_SCOPE_SPARESELL = 'sparesell';
    const DATA_SCOPE_SAMPLESELL = 'samplesell';

    /**
     * @var \Magento\Catalog\Ui\Component\Listing\Columns\Price
     */
    private Price $priceModifier;

    /**
     * Related constructor.
     *
     * @param \Magento\Catalog\Ui\Component\Listing\Columns\Price $priceModifier
     */
    public function __construct(
        Price $priceModifier
    ) {
        $this->priceModifier = $priceModifier;
    }

    /**
     * @param \Magento\Catalog\Ui\DataProvider\Product\Form\Modifier\Related $modify
     * @param array $result
     *
     * @return array
     */
    public function afterModifyMeta($modify, $result)
    {
        if (isset($result[static::GROUP_RELATED]['children'])) {
            $result[static::GROUP_RELATED]['children'][$modify->scopePrefix . static::DATA_SCOPE_SERIESSELL] =
                $this->getSeriessellFieldset($modify);
            $result[static::GROUP_RELATED]['children'][$modify->scopePrefix . static::DATA_SCOPE_ALTERNATIVESELL] =
                $this->getAlternativesellFieldset($modify);
            $result[static::GROUP_RELATED]['children'][$modify->scopePrefix . static::DATA_SCOPE_SPARESELL] =
                $this->getSparesellFieldset($modify);
            $result[static::GROUP_RELATED]['children'][$modify->scopePrefix . static::DATA_SCOPE_SAMPLESELL] =
                $this->getSamplesellFieldset($modify);

            $result[static::GROUP_RELATED]['arguments']['data']['config']['label'] =
                __('Related Products, Series Products, Alternative Products, Spare Products, Samples Products, Up-Sells, Cross-Sells');
        }

        return $result;
    }

    /**
     * Prepares config for the Related products fieldset
     *
     * @param \Magento\Catalog\Ui\DataProvider\Product\Form\Modifier\Related $modify
     *
     * @return array
     */
    protected function getSeriessellFieldset($modify)
    {
        $content = __(
            'My Series Sell Product.'
        );

        return [
            'children' => [
                'button_set' => $modify->getButtonSet(
                    $content,
                    __('Add Series Sell'),
                    $modify->scopePrefix . static::DATA_SCOPE_SERIESSELL
                ),
                'modal' => $modify->getGenericModal(
                    __('Add Series Sell'),
                    $modify->scopePrefix . static::DATA_SCOPE_SERIESSELL
                ),
                static::DATA_SCOPE_SERIESSELL => $modify->getGrid(
                    $modify->scopePrefix . static::DATA_SCOPE_SERIESSELL
                ),
            ],
            'arguments' => [
                'data' => [
                    'config' => [
                        'additionalClasses' => 'admin__fieldset-section',
                        'label' => __('Series sell'),
                        'collapsible' => false,
                        'componentType' => Fieldset::NAME,
                        'dataScope' => '',
                        'sortOrder' => 11,
                    ],
                ],
            ],
        ];
    }

    /**
     * Prepares config for the Related products fieldset
     *
     * @param \Magento\Catalog\Ui\DataProvider\Product\Form\Modifier\Related $modify
     *
     * @return array
     */
    protected function getAlternativesellFieldset($modify)
    {
        $content = __(
            'My Alternative Sell Product.'
        );

        return [
            'children' => [
                'button_set' => $modify->getButtonSet(
                    $content,
                    __('Add Alternative Sell'),
                    $modify->scopePrefix . static::DATA_SCOPE_ALTERNATIVESELL
                ),
                'modal' => $modify->getGenericModal(
                    __('Add Alternative Sell'),
                    $modify->scopePrefix . static::DATA_SCOPE_ALTERNATIVESELL
                ),
                static::DATA_SCOPE_ALTERNATIVESELL => $modify->getGrid(
                    $modify->scopePrefix . static::DATA_SCOPE_ALTERNATIVESELL
                ),
            ],
            'arguments' => [
                'data' => [
                    'config' => [
                        'additionalClasses' => 'admin__fieldset-section',
                        'label' => __('Alternative sell'),
                        'collapsible' => false,
                        'componentType' => Fieldset::NAME,
                        'dataScope' => '',
                        'sortOrder' => 12,
                    ],
                ],
            ],
        ];
    }

    /**
     * Prepares config for the Related products fieldset
     *
     * @param \Magento\Catalog\Ui\DataProvider\Product\Form\Modifier\Related $modify
     *
     * @return array
     */
    protected function getSparesellFieldset($modify)
    {
        $content = __(
            'My Spare Sell Product.'
        );

        return [
            'children' => [
                'button_set' => $modify->getButtonSet(
                    $content,
                    __('Add Spare Sell'),
                    $modify->scopePrefix . static::DATA_SCOPE_SPARESELL
                ),
                'modal' => $modify->getGenericModal(
                    __('Add Spare Sell'),
                    $modify->scopePrefix . static::DATA_SCOPE_SPARESELL
                ),
                static::DATA_SCOPE_SPARESELL => $modify->getGrid(
                    $modify->scopePrefix . static::DATA_SCOPE_SPARESELL
                ),
            ],
            'arguments' => [
                'data' => [
                    'config' => [
                        'additionalClasses' => 'admin__fieldset-section',
                        'label' => __('Spare sell'),
                        'collapsible' => false,
                        'componentType' => Fieldset::NAME,
                        'dataScope' => '',
                        'sortOrder' => 13,
                    ],
                ],
            ],
        ];
    }

    /**
     * Prepares config for the Related products fieldset
     *
     * @param \Magento\Catalog\Ui\DataProvider\Product\Form\Modifier\Related $modify
     *
     * @return array
     */
    protected function getSamplesellFieldset($modify)
    {
        $content = __(
            'My Sample Sell Product.'
        );

        return [
            'children' => [
                'button_set' => $modify->getButtonSet(
                    $content,
                    __('Add Sample Sell'),
                    $modify->scopePrefix . static::DATA_SCOPE_SAMPLESELL
                ),
                'modal' => $modify->getGenericModal(
                    __('Add Sample Sell'),
                    $modify->scopePrefix . static::DATA_SCOPE_SAMPLESELL
                ),
                static::DATA_SCOPE_SAMPLESELL => $modify->getGrid(
                    $modify->scopePrefix . static::DATA_SCOPE_SAMPLESELL
                ),
            ],
            'arguments' => [
                'data' => [
                    'config' => [
                        'additionalClasses' => 'admin__fieldset-section',
                        'label' => __('Sample sell'),
                        'collapsible' => false,
                        'componentType' => Fieldset::NAME,
                        'dataScope' => '',
                        'sortOrder' => 14,
                    ],
                ],
            ],
        ];
    }

    /**
     * @param \Magento\Catalog\Ui\DataProvider\Product\Form\Modifier\Related $modify
     * @param array $data
     *
     * @return mixed
     */
    public function afterModifyData($modify, $data)
    {
        $product = $modify->locator->getProduct();
        $productId = $product->getId();

        if (!$productId) {
            return $data;
        }

        /**
         * Set field name for modifier
         */
        $this->priceModifier->setData('name', 'price');

        $dataScopes = array_merge($modify->getDataScopes(), [
            static::DATA_SCOPE_SERIESSELL,
            static::DATA_SCOPE_ALTERNATIVESELL,
            static::DATA_SCOPE_SPARESELL,
            static::DATA_SCOPE_SAMPLESELL
        ]);
        foreach ($dataScopes as $dataScope) {
            if (in_array($dataScope,  [
                static::DATA_SCOPE_SERIESSELL,
                static::DATA_SCOPE_ALTERNATIVESELL,
                static::DATA_SCOPE_SPARESELL,
                static::DATA_SCOPE_SAMPLESELL
            ])) {
                $data[$productId]['links'][$dataScope] = [];
                foreach ($modify->productLinkRepository->getList($product) as $linkItem) {
                    if ($linkItem->getLinkType() !== $dataScope) {
                        continue;
                    }

                    /** @var \Magento\Catalog\Model\Product $linkedProduct */
                    $linkedProduct = $modify->productRepository->get(
                        $linkItem->getLinkedProductSku(),
                        false,
                        $modify->locator->getStore()->getId()
                    );
                    $data[$productId]['links'][$dataScope][] = $modify->fillData($linkedProduct, $linkItem);
                }
                if (!empty($data[$productId]['links'][$dataScope])) {
                    $dataMap = $this->priceModifier->prepareDataSource(
                        [
                            'data' => [
                                'items' => $data[$productId]['links'][$dataScope],
                            ],
                        ]
                    );
                    $data[$productId]['links'][$dataScope] = $dataMap['data']['items'];
                }
            }
        }

        return $data;
    }

}
