<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Catalog\Plugin;

class ProductListSamplesellPlugin
{
    /**
     * @var \Xtwo\Catalog\Model\ProductFactory
     */
    protected \Xtwo\Catalog\Model\ProductFactory $productFactory;

    /**
     * ProductListSamplesellPlugin constructor.
     *
     * @param \Xtwo\Catalog\Model\ProductFactory $productFactory
     */
    public function __construct(
        \Xtwo\Catalog\Model\ProductFactory $productFactory
    ) {
        $this->productFactory = $productFactory;
    }

    /**
     * @param \Xtwo\Catalog\Model\ProductLink\CollectionProvider\Samplesell $provider
     * @param \Xtwo\Catalog\Model\Product $product
     *
     * @return array
     */
    public function beforeGetLinkedProducts($provider, $product)
    {
        $currentProduct = $this->productFactory->create()->load($product->getId());

        return [$currentProduct];
    }

}
