<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Catalog\Model\ResourceModel;

use Magento\Catalog\Model\ResourceModel\Product\Relation as ProductRelation;
use Magento\ConfigurableProduct\Model\AttributeOptionProviderInterface;
use Magento\ConfigurableProduct\Model\ResourceModel\Attribute\OptionProvider;
use Magento\Framework\App\ScopeResolverInterface;
use Magento\Framework\Model\ResourceModel\Db\Context as DbContext;

class Configurable extends \Magento\ConfigurableProduct\Model\ResourceModel\Product\Type\Configurable
{
    /**
     * @var OptionProvider
     */
    private $optionProvider;

    /**
     * @param DbContext $context
     * @param ProductRelation $catalogProductRelation
     * @param string $connectionName
     * @param ScopeResolverInterface $scopeResolver
     * @param AttributeOptionProviderInterface $attributeOptionProvider
     * @param OptionProvider $optionProvider
     */
    public function __construct(
        DbContext $context,
        ProductRelation $catalogProductRelation,
        ScopeResolverInterface $scopeResolver = null,
        AttributeOptionProviderInterface $attributeOptionProvider,
        OptionProvider $optionProvider,
        $connectionName = null
    ) {
        $this->optionProvider = $optionProvider;
        parent::__construct(
            $context,
            $catalogProductRelation,
            $connectionName,
            $scopeResolver,
            $attributeOptionProvider,
            $optionProvider
        );

    }

    /**
     * Retrieve parent ids array by required child
     *
     * @param int|array $childId
     *
     * @return string[]
     */
    public function getParentIdsByChildForConfigurables($childId)
    {
        $select = $this->getConnection()
            ->select()
            ->from(['l' => $this->getMainTable()], ['product_id'])
            ->join(
                ['e' => $this->getTable('catalog_product_entity')],
                'e.' . $this->optionProvider->getProductEntityLinkField() . ' = l.parent_id',
                ['e.entity_id']
            )->where('l.product_id IN(?)', $childId);
        $parentIds = $this->getConnection()->fetchAll($select);

        return $parentIds;
    }
}
