<?php

namespace Xtwo\Catalog\Model\ProductLink;

use Magento\Catalog\Model\Product;
use Magento\Catalog\Model\ProductLink\Converter\ConverterPool;
use Magento\Framework\Exception\NoSuchEntityException;

class CollectionProvider extends \Magento\Catalog\Model\ProductLink\CollectionProvider
{
    /**
     * Get product collection by link type
     *
     * @param Product $product
     * @param string $type
     * @return array
     * @throws NoSuchEntityException
     */
    public function getCollection(Product $product, $type)
    {
        if (!isset($this->providers[$type])) {
            throw new NoSuchEntityException(__("The collection provider isn't registered."));
        }

        $products = $this->providers[$type]->getLinkedProducts($product);
        if ($products === null) {
            $products = [];
        }

        $linkData = $this->prepareList($products, $type);
        usort(
            $linkData,
            function (array $itemA, array $itemB): int {
                $posA = (int)$itemA['position'];
                $posB = (int)$itemB['position'];

                return (($posA - $posB) > 0) ? 1 : -1;  // for PHP 7 and 8 consistency
            }
        );

        return $linkData;
    }

    /**
     * Extract link data from linked products.
     *
     * @param Product[] $linkedProducts
     * @param string $type
     * @return array
     */
    protected function prepareList(array $linkedProducts, string $type): array
    {
        $converter = $this->converterPool->getConverter($type);
        $links = [];
        foreach ($linkedProducts as $item) {
            $itemId = $item->getId();
            $links[$itemId] = $converter->convert($item);
            $links[$itemId]['position'] = $links[$itemId]['position'] ?? 0;
            $links[$itemId]['link_type'] = $type;
        }

        return $links;
    }
}
