<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Catalog\Model;

class Product extends \Magento\Catalog\Model\Product
{
    const LINK_TYPE_SERIESSELL = 6;
    const LINK_TYPE_ALTERNATIVESELL = 7;
    const LINK_TYPE_SPARESELL = 8;
    const LINK_TYPE_SAMPLESELL = 9;

    /**
     * Retrieve array of related products
     *
     * @return array
     */
    public function getSeriessellProducts()
    {
        if (!$this->hasSeriessellProducts()) {
            $products = [];
            $collection = $this->getSeriessellProductCollection();
            foreach ($collection as $product) {
                $products[] = $product;
            }
            $this->setSeriessellProducts($products);
        }

        return $this->getData('seriessell_products');
    }

    /**
     * Retrieve related products identifiers
     *
     * @return array
     */
    public function getSeriessellProductIds()
    {
        if (!$this->hasSeriessellProductIds()) {
            $ids = [];
            foreach ($this->getSeriessellProducts() as $product) {
                $ids[] = $product->getId();
            }
            $this->setSeriessellProductIds($ids);
        }

        return [$this->getData('seriessell_product_ids')];
    }

    /**
     * Retrieve collection related product
     *
     * @return \Magento\Catalog\Model\ResourceModel\Product\Link\Product\Collection
     */
    public function getSeriessellProductCollection()
    {
        $collection = $this->getLinkInstance()->setLinkTypeId(static::LINK_TYPE_SERIESSELL)
            ->getProductCollection()
            ->setIsStrongMode();
        $collection->setProduct($this);

        return $collection;
    }

    /**
     * Retrieve array of related products
     *
     * @return array
     */
    public function getAlternativesellProducts()
    {
        if (!$this->hasAlternativesellProducts()) {
            $products = [];
            $collection = $this->getAlternativesellProductCollection();
            foreach ($collection as $product) {
                $products[] = $product;
            }
            $this->setAlternativesellProducts($products);
        }

        return $this->getData('alternativesell_products');
    }

    /**
     * Retrieve related products identifiers
     *
     * @return array
     */
    public function getAlternativesellProductIds()
    {
        if (!$this->hasAlternativesellProductIds()) {
            $ids = [];
            foreach ($this->getSeriessellProducts() as $product) {
                $ids[] = $product->getId();
            }
            $this->setAlternativesellProductIds($ids);
        }

        return [$this->getData('alternativesell_product_ids')];
    }

    /**
     * Retrieve collection related product
     *
     * @return \Magento\Catalog\Model\ResourceModel\Product\Link\Product\Collection
     */
    public function getAlternativesellProductCollection()
    {
        $collection = $this->getLinkInstance()->setLinkTypeId(static::LINK_TYPE_ALTERNATIVESELL)
            ->getProductCollection()
            ->setIsStrongMode();
        $collection->setProduct($this);

        return $collection;
    }

    /**
     * Retrieve array of related products
     *
     * @return array
     */
    public function getSparesellProducts()
    {
        if (!$this->hasSparesellProducts()) {
            $products = [];
            $collection = $this->getSparesellProductCollection();
            foreach ($collection as $product) {
                $products[] = $product;
            }
            $this->setSparesellProducts($products);
        }

        return $this->getData('sparesell_products');
    }

    /**
     * Retrieve related products identifiers
     *
     * @return array
     */
    public function getSparesellProductIds()
    {
        if (!$this->hasSparesellProductIds()) {
            $ids = [];
            foreach ($this->getSparesellProducts() as $product) {
                $ids[] = $product->getId();
            }
            $this->setSparesellProductIds($ids);
        }

        return [$this->getData('sparesell_product_ids')];
    }

    /**
     * Retrieve collection related product
     *
     * @return \Magento\Catalog\Model\ResourceModel\Product\Link\Product\Collection
     */
    public function getSparesellProductCollection()
    {
        $collection = $this->getLinkInstance()->setLinkTypeId(static::LINK_TYPE_SPARESELL)
            ->getProductCollection()
            ->setIsStrongMode();
        $collection->setProduct($this);

        return $collection;
    }

    /**
     * Retrieve array of related products
     *
     * @return array
     */
    public function getSamplesellProducts()
    {
        if (!$this->hasSamplesellProducts()) {
            $products = [];
            $collection = $this->getSamplesellProductCollection();
            foreach ($collection as $product) {
                $products[] = $product;
            }
            $this->setSamplesellProducts($products);
        }

        return $this->getData('samplesell_products');
    }

    /**
     * Retrieve related products identifiers
     *
     * @return array
     */
    public function getSamplesellProductIds()
    {
        if (!$this->hasSamplesellProductIds()) {
            $ids = [];
            foreach ($this->getSamplesellProducts() as $product) {
                $ids[] = $product->getId();
            }
            $this->setSamplesellProductIds($ids);
        }

        return [$this->getData('samplesell_product_ids')];
    }

    /**
     * Retrieve collection related product
     *
     * @return \Magento\Catalog\Model\ResourceModel\Product\Link\Product\Collection
     */
    public function getSamplesellProductCollection()
    {
        $collection = $this->getLinkInstance()->setLinkTypeId(static::LINK_TYPE_SAMPLESELL)
            ->getProductCollection()
            ->setIsStrongMode();
        $collection->setProduct($this);

        return $collection;
    }

}
