<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Catalog\Model;

use Magento\Catalog\Api\ProductRepositoryInterface;
use Xtwo\Catalog\Model\ResourceModel\Configurable as ConfigurableResource;
use Magento\Framework\Api\FilterBuilder;
use Magento\Framework\Api\SearchCriteriaBuilder;

class Configurable
{
    /**
     * @var \Xtwo\Catalog\Model\ResourceModel\Configurable
     */
    private ConfigurableResource $catalogProductTypeConfigurableResource;
    /**
     * @var \Magento\Framework\Api\SearchCriteriaBuilder
     */
    private SearchCriteriaBuilder $searchCriteriaBuilder;
    /**
     * @var \Magento\Catalog\Api\ProductRepositoryInterface
     */
    private ProductRepositoryInterface $productRepository;
    /**
     * @var \Magento\Framework\Api\FilterBuilder
     */
    private FilterBuilder $filterBuilder;
    /**
     * @var array
     */
    private $simpleToConfigurableIds = [];

    /**
     * Configurable constructor.
     *
     * @param \Xtwo\Catalog\Model\ResourceModel\Configurable $catalogProductTypeConfigurable
     * @param \Magento\Framework\Api\SearchCriteriaBuilder $searchCriteriaBuilder
     * @param \Magento\Framework\Api\FilterBuilder $filterBuilder
     * @param \Magento\Catalog\Api\ProductRepositoryInterface $productRepository
     */
    public function __construct(
        ConfigurableResource $catalogProductTypeConfigurable,
        SearchCriteriaBuilder $searchCriteriaBuilder,
        FilterBuilder $filterBuilder,
        ProductRepositoryInterface $productRepository
    ) {
        $this->catalogProductTypeConfigurableResource = $catalogProductTypeConfigurable;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
        $this->productRepository = $productRepository;
        $this->filterBuilder = $filterBuilder;
    }

    /**
     * @param array|\Magento\Catalog\Model\ResourceModel\Product\Collection $productCollection
     * @param string|array $attributeCode
     * @param bool $flagAttributeText
     * @param int $limit
     *
     * @return array
     */
    public function getParentIdsByChildForConfigurables(
        $simpleProductCollection,
        $attributeCode,
        bool $flagAttributeText = false
        /*,int $limit = 100*/
    ) {
        $result = [];

        foreach ($simpleProductCollection as $product) {
            if (is_array($attributeCode)) {
                $values = [];
                foreach ($attributeCode as $productAttributeCode) {
                    $values[$productAttributeCode] = ($flagAttributeText)
                        ? [
                            'option_id' => $product->getData($attributeCode),
                            'option_text' => $product->getAttributeText[$productAttributeCode],
                        ]
                        : $product->getData($attributeCode);
                }
                $result[$this->simpleToConfigurableIds[$product->getId()]] = $values;
            } else {
                $result[$this->simpleToConfigurableIds[$product->getId()]] = ($flagAttributeText)
                    ? [
                        'option_id' => $product->getData($attributeCode),
                        'option_text' => $product->getAttributeText($attributeCode),
                    ]
                    : $product->getData($attributeCode);
            }
        }

        return $result;
    }

    /**
     * @param array|\Magento\Catalog\Model\ResourceModel\Product\Collection $productCollection
     * @param int $limit
     *
     * @return \Magento\Catalog\Api\Data\ProductInterface[]
     */
    public function getParentIdsByChildForConfigurablesCollection($productCollection, $limit = 100)
    {
        $simpleIds = [];

        foreach ($productCollection as $product) {
            if ($product->getDefaultConfigurationId() !== null) {
                $simpleIds[] = $product->getDefaultConfigurationId();
            }
        }
        $parentsByChild = $this->catalogProductTypeConfigurableResource->getParentIdsByChildForConfigurables($simpleIds);

        foreach ($parentsByChild as $parentByChild) {
            $this->simpleToConfigurableIds[$parentByChild['product_id']] = $parentByChild['entity_id'];
        }

        $this->searchCriteriaBuilder->addFilters(
            [
                $this->filterBuilder
                    ->setField('entity_id')
                    ->setConditionType('in')
                    ->setValue($simpleIds)
                    ->create(),
            ]
        );
        $this->searchCriteriaBuilder->setPageSize($limit);

        $searchCriteria = $this->searchCriteriaBuilder->create();
        return $this->productRepository->getList($searchCriteria)->getItems();
    }

    /**
     *
     * @return array
     */
    public function getSimpleToConfigurableIds()
    {
        return $this->simpleToConfigurableIds;
    }
}
