<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Catalog\Helper;

use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Framework\Registry;
use Magento\Store\Model\ScopeInterface;
use Xtwo\Catalog\Model\Configurable;

class Shipping extends AbstractHelper
{
    /**
     * @var \Magento\Framework\Registry
     */
    private Registry $registry;
    /**
     * @var \Magento\Catalog\Api\ProductRepositoryInterface
     */
    private ProductRepositoryInterface $productRepository;
    /**
     * @var \Xtwo\Catalog\Model\Configurable
     */
    private Configurable $configurable;

    /**
     * Shipping constructor.
     *
     * @param \Magento\Framework\App\Helper\Context $context
     * @param \Magento\Framework\Registry $registry
     * @param \Magento\Catalog\Api\ProductRepositoryInterface $productRepository
     * @param \Xtwo\Catalog\Model\Configurable $configurable
     */
    public function __construct(
        Context $context,
        Registry $registry,
        ProductRepositoryInterface $productRepository,
        Configurable $configurable
    ) {
        $this->registry = $registry;
        $this->productRepository = $productRepository;
        parent::__construct($context);

        $this->configurable = $configurable;
    }

    /**
     * @param \Magento\Catalog\Api\Data\ProductInterface $product
     *
     * @return string
     */
    public function getShippingtime($product = null)
    {
        if (empty($product)) {
            $product = $this->getProduct();
        }

        $deliveryTimeOptionId = $product->getData('delivery_time');
        $deliveryTimeText = $this->getShippingtimeValue($product);
        $caseMapping = $this->getCaseMapping();

        return $this->getShippingTimeHtml($deliveryTimeOptionId, $deliveryTimeText, $product->getId(), $caseMapping);
    }

    /**
     * @param int $deliveryTimeOptionId
     * @param string $deliveryTimeText
     * @param int $productId
     * @param array $caseMapping
     *
     * @return string
     */
    protected function getShippingTimeHtml($deliveryTimeOptionId, $deliveryTimeText, $productId, $caseMapping)
    {
        $case = array_key_exists($deliveryTimeOptionId, $caseMapping) ? $caseMapping[$deliveryTimeOptionId] : 1;

        return '<span class="shipping-time case' . $case . '" id="shippingtime-' . $productId . '"> '
            . $deliveryTimeText . '</span>';
    }

    /**
     * @param array|\Magento\Catalog\Model\ResourceModel\Product\Collection $productCollection
     *
     * @return array
     */
    public function getShippingTimeForProductCollection($productCollection)
    {
        $result = $this->configurable
            ->getParentIdsByChildForConfigurables($this->configurable->getParentIdsByChildForConfigurablesCollection($productCollection), 'delivery_time', true);
        $caseMapping = $this->getCaseMapping();
        $timeHtml = [];
        foreach ($productCollection as $product) {
            if (!empty($result[$product->getId()])) {
                $timeHtml[$product->getId()] = $this->getShippingTimeHtml(
                    $result[$product->getId()]['option_id'],
                    $result[$product->getId()]['option_text'],
                    $product->getId(),
                    $caseMapping
                );
            }
        }
        return $timeHtml;

    }

    /**
     * @return \Magento\Catalog\Api\Data\ProductInterface
     */
    protected function getProduct()
    {
        $product = $this->registry->registry('simple_product');
        if (!$product) {
            $product = $this->registry->registry('current_product');
        }
        if (!$product) {
            $product = $this->registry->registry('product');
        }
        if ($product) {
            if ($defaultId = $product->getData('default_configuration_id')) {
                $product = $this->productRepository->getById($defaultId);
            }
        }

        return $product;
    }

    /**
     * @return array
     */
    protected function getCaseMapping()
    {
        $config = $this->scopeConfig->getValue(
            'stamm_mailreminder/mailreminder/mapping_delivery'/*,
            ScopeInterface::SCOPE_STORE()*/
        );
        $result = [];
        $itemData = explode(',', $config);
        foreach ($itemData as $line) {
            $item = explode(':', $line);
            if (count($item) == 2) {
                $result[$item[0]] = $item[1];
            }
        }

        return $result;
    }

    /**
     * @param \Magento\Catalog\Api\Data\ProductInterface $product
     *
     * @return string
     */
    public function getShippingtimeValue($product)
    {
        if ($product == null) {
            $product = $this->getProduct();
        }
        $deliveryTime = '';
        if ($product && $product->getId()) {
            $deliveryTime = $product->getAttributeText('delivery_time');
        }

        return $deliveryTime;

    }

    /**
     * @param \Magento\Catalog\Api\Data\ProductInterface $product
     *
     * @return array
     */
    public function getShippingtimeForCart($product = null)
    {
        if (empty($product)) {
            $product = $this->getProduct();
        }

        $delivery_time_text = $this->getShippingtimeValue($product);
        $caseMapping = $this->getCaseMapping();
        $deliveryTimeOptionId = $product->getData('delivery_time');
        $case = array_key_exists($deliveryTimeOptionId, $caseMapping) ? $caseMapping[$deliveryTimeOptionId] : 1;

        $data['case'] = $case;
        $data['delivery_time_text'] = $delivery_time_text;

        return $data;

    }
}

?>
