<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Catalog\Helper\Product;

use Magento\Framework\App\Helper\AbstractHelper;
use Xtwo\Catalog\Model\Configurable;
use Magento\Framework\Registry;

class DefaultSimpleProduct extends AbstractHelper
{
    /**
     * @var \Xtwo\Catalog\Model\Configurable
     */
    private Configurable $configurable;
    /**
     * @var \Magento\Framework\Registry
     */
    private Registry $registry;

    /**
     * DefaultSimpleProduct constructor.
     *
     * @param \Xtwo\Catalog\Model\Configurable $configurable
     * @param \Magento\Framework\Registry $registry
     */
    public function __construct(
        Configurable $configurable,
        Registry $registry
    ) {
        $this->configurable = $configurable;
        $this->registry = $registry;
    }

    /**
     * @param $productCollection
     */
    public function getSimpleProducts($productCollection)
    {
        $result = [];
        $productCollection = $this->configurable->getParentIdsByChildForConfigurablesCollection($productCollection);
        $simpleToConfigurableIds = $this->configurable->getSimpleToConfigurableIds();

        foreach ($productCollection as $product) {
            $result[$simpleToConfigurableIds[$product->getId()]] = $product;
        }
        return $result;
    }

    public function getSimpleProduct()
    {
        return $this->registry->registry('simple_product');
    }
}
