<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 *//**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Catalog\Controller\Product;

use Exception;
use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\HttpGetActionInterface as HttpGetActionInterface;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\Result\JsonFactory;
use Magento\Framework\Registry;
use Magento\Framework\View\Result\PageFactory;
use Psr\Log\LoggerInterface;
use Xtwo\AttributeOption\Helper\Image as ImageHelper;
use Xtwo\AttributeOption\Model\Image;

class Attributes extends Action implements HttpGetActionInterface
{
    /**
     * @var \Magento\Framework\Registry
     */
    private Registry $registry;
    /**
     * @var \Magento\Framework\Controller\Result\JsonFactory
     */
    private JsonFactory $resultJsonFactory;
    /**
     * @var \Magento\Framework\View\Result\PageFactory
     */
    private PageFactory $resultPageFactory;
    /**
     * @var \Magento\Catalog\Api\ProductRepositoryInterface
     */
    private ProductRepositoryInterface $productRepository;
    /**
     * @var \Psr\Log\LoggerInterface
     */
    private LoggerInterface $logger;

    /**
     * @var string[]
     */
    static private $relatedBlocks = [
        'related',
        'upsell',
        'seriessell',
        'alternativesell',
        'samplesell',
        'sparesell',
        'crosssell'
    ];
    /**
     * @var \Xtwo\AttributeOption\Helper\Image
     */
    private ImageHelper $imageHelper;

    /**
     * Attributes constructor.
     *
     * @param \Magento\Framework\App\Action\Context $context
     * @param \Magento\Framework\Registry $registry
     * @param \Magento\Catalog\Api\ProductRepositoryInterface $productRepository
     * @param \Magento\Framework\Controller\Result\JsonFactory $resultJsonFactory
     * @param \Magento\Framework\View\Result\PageFactory $resultPageFactory
     * @param \Psr\Log\LoggerInterface $logger
     * @param \Xtwo\AttributeOption\Helper\Image $imageHelper
     */
    public function __construct(
        Context $context,
        Registry $registry,
        ProductRepositoryInterface $productRepository,
        JsonFactory $resultJsonFactory,
        PageFactory $resultPageFactory,
        LoggerInterface $logger,
        ImageHelper $imageHelper
    ) {
        parent::__construct($context);
        $this->registry = $registry;
        $this->resultJsonFactory = $resultJsonFactory;
        $this->resultPageFactory = $resultPageFactory;
        $this->productRepository = $productRepository;
        $this->logger = $logger;
        $this->imageHelper = $imageHelper;
    }

    /**
     * Dispatch request
     *
     * @return \Magento\Framework\Controller\ResultInterface|ResponseInterface
     * @throws \Magento\Framework\Exception\NotFoundException
     */
    public function execute()
    {
        $resultJson = $this->resultJsonFactory->create();

        $simpleProductId = $this->getRequest()->getParam('simpleProductId');
        $configurableProductId = $this->getRequest()->getParam('configurableProductId');
        if (empty($simpleProductId)) {
            if (!empty($configurableProductId)) {
                $configurableProduct = $this->productRepository->getById($configurableProductId);
                if ($configurableProduct->getTypeId() === 'configurable'
                    && $configurableProduct->getDefaultConfigurationId() !== null) {
                    $simpleProductId = $configurableProduct->getDefaultConfigurationId();
                }
            } else {
                return $resultJson->setData(['error' => true]);
            }
        }

        $this->registry->register('simple_product_id', $simpleProductId);

        $resultPage = $this->resultPageFactory->create();
        $result = [];

        try {
            $simpleProduct = $this->productRepository->getById($simpleProductId);
            $this->registry->register('product', $simpleProduct);
            foreach (self::$relatedBlocks as $relatedBlock) {
                $result[$relatedBlock] = $resultPage
                    ->getLayout()
                    ->getBlock('catalog.product.' . $relatedBlock)
                    ->toHtml();
            }
        } catch (Exception $exception) {
            $this->logger->error($exception->getMessage());
            return $resultJson->setData(['error' => true]);
        }

        $layerImage = $this->imageHelper->getLayerImage($simpleProduct);
        $layerImagePath = $this->_url->getBaseUrl() . 'media/' . Image::PATH_TO_LOGO;

        return $resultJson->setData(
            [
                'url' => $simpleProduct->getProductUrl(),
                'attributes_data' => $resultPage->getLayout()->getBlock('product.custom.attributes')->toHtml(),
                'relatedBlocks' => $result,
                'main_attributes' => $resultPage->getLayout()->getBlock('product.info.main.attributes')->toHtml(),
                'title' => $simpleProduct->getName(),
                'layer_image' => !empty($layerImage) ? $layerImagePath : ''
            ]
        );
    }
}
