<?php
namespace Xtwo\CartgettotalApi\Model;

use Xtwo\CartgettotalApi\Api\XtwoCartgettotalApiInterface;
use Magento\Quote\Api\CartTotalRepositoryInterface;
use Magento\Quote\Model\QuoteRepository;
use Magento\Quote\Api\CartRepositoryInterface;
use Magento\Quote\Api\Data\TotalsInterfaceFactory;
use Magento\Framework\Api\DataObjectHelper;
use Magento\Quote\Model\Cart\Totals\ItemConverter;
use Magento\Quote\Api\Data\TotalSegmentInterface;
use Magento\Framework\Api\ExtensibleDataInterface;
use Magento\Quote\Api\CouponManagementInterface;
use Magento\Quote\Api\Data\TotalSegmentInterfaceFactory;
use Magento\Customer\Api\CustomerRepositoryInterface;

class CustomTotal implements CartTotalRepositoryInterface
{
	/**
   * @var \Magento\Framework\App\Config\ScopeConfigInterface
   */
  
	protected $scopeConfig;
    private $quoteRepository;
	private $totalsFactory;
    private $dataObjectHelper;
    private $itemConverter;
	protected $couponService;
	protected $factory;
	protected $cartRepository;
	protected $_productloader;
	protected $_storeManager;
	private $customerRepository;


    public function __construct(
	 CartRepositoryInterface $quoteRepository,
	 TotalsInterfaceFactory $totalsFactory,
	 DataObjectHelper $dataObjectHelper,
	 CouponManagementInterface $couponService,
	 TotalSegmentInterfaceFactory $factory,
	 ItemConverter $converter,
	 \Magento\Catalog\Api\ProductRepositoryInterface $productrepository,
     \Magento\Store\Model\StoreManagerInterface $storemanager,
	 \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
	 CustomerRepositoryInterface $customerRepository // Injecting CustomerRepositoryInterface
	)
    {
       $this->quoteRepository = $quoteRepository;
	   $this->totalsFactory = $totalsFactory;
	   $this->dataObjectHelper = $dataObjectHelper;
	   $this->couponService = $couponService;
	   $this->factory = $factory;
	   $this->itemConverter = $converter;
	   $this->productrepository = $productrepository;
       $this->_storeManager =  $storemanager;
	   $this->scopeConfig = $scopeConfig;
	   $this->customerRepository = $customerRepository; // Initializing CustomerRepositoryInterface
    }

    /**
     * @inheritdoc
     */

	public function get($cartId)
    {
		/** @var \Magento\Quote\Model\Quote $quote */
        $quote = $this->quoteRepository->getActive($cartId);
		
		$restrictEnabled = $this->scopeConfig->getValue('restrict/shippingmethod/active',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
		
		$restrictedSkusList = "";
		$restrictedSkusList = $this->scopeConfig->getValue('restrict/shippingmethod/restrict_skus',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
			
		$restrictedSkusArray =[];
			if(!empty($restrictedSkusList)){
				$restrictedSkusArray = explode(',', $restrictedSkusList);
			}
			
		//vat
		 // Fetch customer data using CustomerRepositoryInterface
		 $customerId = $quote->getCustomerId();
		 if($customerId)
		 {
			 $customer = $this->customerRepository->getById($customerId);
			 $customerGroupIdFromAccount = $customer->getGroupId(); 
			
			 $customerGroupId = $quote->getCustomerGroupId(); 
			
			if ($customerGroupIdFromAccount !== $customerGroupId) {
				//$this->quoteRepository->delete($quote);
				$quote->setCustomerGroupId($customerGroupIdFromAccount);
				
				$quote->collectTotals();
				$this->quoteRepository->save($quote);	
				$quote->getCustomerGroupId(); 
				
			}	
		 }		
		//vat
        if ($quote->isVirtual()) {
            $quote->collectTotals();
            $addressTotalsData = $quote->getBillingAddress()->getData();
            $addressTotals = $quote->getBillingAddress()->getTotals();
        } else {
            $addressTotalsData = $quote->getShippingAddress()->getData();
            $addressTotals = $quote->getShippingAddress()->getTotals();
        }
        unset($addressTotalsData[ExtensibleDataInterface::EXTENSION_ATTRIBUTES_KEY]);

        /** @var QuoteTotalsInterface $quoteTotals */
        $quoteTotals = $this->totalsFactory->create();
        $this->dataObjectHelper->populateWithArray(
            $quoteTotals,
            $addressTotalsData,
            QuoteTotalsInterface::class
        );
		$quoteItems = $quote->getItemsCollection();
		$showitem = [];
		$store = $this->_storeManager->getStore();
		foreach ($quoteItems as $key=>$item) {

               // Retrieve cart item information
			$product = $this->productrepository->get($item->getSku());

			$productImageUrl = $product->getImage();
			$delivery = $product->getAttributeText('delivery_time');
			//print_r($item->getSku());
			$showitem[$key]["id"] = $item->getId();
			$showitem[$key]["quoteid"] = $item->getQuoteId();
			$showitem[$key]["name"] = $item->getName();
			$showitem[$key]["sku"] = $item->getSku();
			$showitem[$key]["weight"] = $item->getWeight();
			$showitem[$key]["price"] = $item->getPriceInclTax();
			$showitem[$key]["qty"] = $item->getQty();
			$showitem[$key]["image"] = $productImageUrl;
			$showitem[$key]["delivery_time"] = $delivery;
			$showitem[$key]["url_key"] = $product->getUrlKey();
			$showitem[$key]["tax"] = $item->getTaxPercent();
			$showitem[$key]["tax_id"] = $item->getTaxClassId();
			$showitem[$key]["product_type"] = $item->getProductType();
			$showitem[$key]["discount_amount"] = $item->getDiscountAmount();
			// Check if the item's SKU is in the restricted SKUs array
			if(!empty($restrictedSkusArray) && $restrictEnabled){
				if (in_array($item->getSku(), $restrictedSkusArray)) {
					$showitem[$key]["restric_shipping"] = "yes";
				}
				else
				{
					$showitem[$key]["restric_shipping"] = "No";
				}
			}
			
		}

        $calculatedTotals = $this->process($addressTotals);
        $quoteTotals->setTotalSegments($calculatedTotals);
        $amount = $quoteTotals->getGrandTotal() - $quoteTotals->getTaxAmount();
        $amount = $amount > 0 ? $amount : 0;
		$quoteTotals->setCouponCode($this->couponService->get($cartId));
        $quoteTotals->setGrandTotal($amount);
        if($quoteTotals->getTaxAmount() == 0){
            $quoteTotals->setBaseGrandTotal($amount);
        }
        $quoteTotals->setItems($showitem);
        $quoteTotals->setItemsQty($quote->getItemsQty());
		$quoteTotals->setWeeeTaxAppliedAmount($quote->getId());  // quote id in currency
        $quoteTotals->setBaseCurrencyCode($quote->getBaseCurrencyCode());
        $quoteTotals->setQuoteCurrencyCode($quote->getQuoteCurrencyCode());  // quote id in currency
		

        return $quoteTotals;

    }
	public function process($addressTotals)
    {
        $data = [];
        /** @var \Magento\Quote\Model\Quote\Address\Total $addressTotal */
        foreach ($addressTotals as $addressTotal) {
            $pureData = [
                TotalSegmentInterface::CODE => $addressTotal->getCode(),
                TotalSegmentInterface::TITLE => '',
                TotalSegmentInterface::VALUE => $addressTotal->getValue(),
                TotalSegmentInterface::AREA => $addressTotal->getArea(),
            ];
            if (is_object($addressTotal->getTitle())) {
                $pureData[TotalSegmentInterface::TITLE] = $addressTotal->getTitle()->render();
            }
            /** @var \Magento\Quote\Model\Cart\TotalSegment $total */
            $total = $this->factory->create();
            $total->setData($pureData);
            $data[$addressTotal->getCode()] = $total;
        }
        return $data;

	}
	 public function getCode()
    {
        return $this->getData(self::CODE);
    }
}