<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Buyerprotect
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Buyerprotect\Setup;

use Magento\Eav\Setup\EavSetup;
use Magento\Eav\Setup\EavSetupFactory;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\UpgradeDataInterface;

class UpgradeData implements UpgradeDataInterface
{

    public function __construct(EavSetupFactory $eavSetupFactory)
    {
       $this->eavSetupFactory = $eavSetupFactory;
    }


    public function upgrade(ModuleDataSetupInterface $setup, ModuleContextInterface $context)
    { 
        /** @var EavSetup $eavSetup */
        $eavSetup = $this->eavSetupFactory->create(['setup' => $setup]);
        $setup->startSetup();
        if (version_compare($context->getVersion(), '0.0.1', '<')) {

            $entityType = $eavSetup->getEntityTypeId('catalog_product');

           // $eavSetup->updateAttribute('catalog_product', $field, 'apply_to', join(',', $applyTo));
       
       
            $fieldList = array(
                'price',
                'cost',
               'special_from_date',
                'special_to_date',
                'minimal_price',
                'cost',
               'tier_price',
                'weight',
                'tax_class_id'
            );
            
            
            // make these attributes applicable to downloadable products
            foreach ($fieldList as $field) {
            
             
              $applyTo = explode(
                ',',
                $eavSetup->getAttribute(\Magento\Catalog\Model\Product::ENTITY, $field, 'apply_to')
            );
             
              // var_dump($applyTo);
                if (!in_array('buyerprotect', $applyTo)) {
                    $applyTo[] = 'buyerprotect';
                    $eavSetup->updateAttribute(\Magento\Catalog\Model\Product::ENTITY, $field, 'apply_to', join(',', $applyTo));

                    
                }
            }

            $applyTo = explode(',', $eavSetup->getAttribute(\Magento\Catalog\Model\Product::ENTITY, 'cost', 'apply_to'));
            unset($applyTo[array_search('buyerprotect', $applyTo)]);
            $eavSetup->updateAttribute(\Magento\Catalog\Model\Product::ENTITY, 'cost', 'apply_to', implode(',', $applyTo));
          
        }

        $setup->endSetup();

        // added 1
     /*   $setup->startSetup();
$templatePath = \Xtwo\Buyerprotect\Model\Setup::MIGRATION_TEMPLATE_PATH;
$templateSuffix = \Xtwo\Buyerprotect\Model\Setup::MIGRATION_TEMPLATE_SUFFIX;

$templateSubject = 'SOAP Übermittlungsfehler -- Kunden-Id: {{var tsSoapData.getTsId()}} -- '
                 . 'Bestellungs-Id: {{var tsSoapData.getShopOrderId()}}';

$emailTemplates = array(
    'ts_buyerprotect_error_email_de-DE' => array(
        'template_code' => 'Trusted Shops Käuferschutz SOAP Fehler DE',
        'template_subject' => $templateSubject
    )
);

foreach ($emailTemplates as $fileName => $template) {
    $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
    $directory = $objectManager->get('\Magento\Framework\Filesystem\DirectoryList');
     $rootPath  =  $directory->getRoot();
 
   $file = $rootPath . $templatePath . $fileName . $templateSuffix;
    $content = file_get_contents($file);
    $template['template_text'] = $content;

    // $this->createEmailTemplate($template['template_code'], $template);
}*/


        // added 1


        // added 2
/*
        $templatePath = \Xtwo\Buyerprotect\Model\Setup::MIGRATION_TEMPLATE_PATH;
$templateSuffix = \Xtwo\Buyerprotect\Model\Setup::MIGRATION_TEMPLATE_SUFFIX;

$templateSubject = 'SOAP Übermittlungsfehler -- Kunden-Id: {{var tsSoapData.getTsId()}} -- '
                 . 'Bestellungs-Id: {{var tsSoapData.getShopOrderId()}}';

$emailTemplates = array(
    'ts_buyerprotect_error_email_de-DE' => array(
        'template_code' => 'Trusted Shops Käuferschutz SOAP Fehler DE',
        'template_subject' => $templateSubject
    )
);

$objectManager = \Magento\Framework\App\ObjectManager::getInstance();
    $directory = $objectManager->get('\Magento\Framework\Filesystem\DirectoryList');
     $rootPath  =  $directory->getRoot();

foreach ($emailTemplates as $fileName => $template) {
    // $file = Mage::getBaseDir() . $templatePath . $fileName . $templateSuffix;
    $file = $rootPath . $templatePath . $fileName . $templateSuffix;
    $content = file_get_contents($file);
    $template['template_text'] = $content;

    // $this->updateEmailTemplate($template['template_code'], $template);
}

        // added 2


        // added 3

        $adapter = $setup->getConnection();

$select = $adapter->select();
$buyerprotectionDataPath = array(
    'buyerprotection/data/trustedshops_certificate_logo_code',
    'buyerprotection/data/ts_background_img',
    'buyerprotection/data/ts_logo_img',
);

$select->from($adapter->getTableName('core_config_data'));
foreach ($buyerprotectionDataPath as $path) {
    $select->orWhere('path LIKE ?', $path);
}



$sql = $select->deleteFromSelect($adapter->getTableName('core_config_data'));
$adapter->query($sql);
$setup->endSetup(); */
        // adde 3
    }
}