<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Buyerprotect
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */
 
namespace Xtwo\Buyerprotect\Model\Type;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Store\Model\ScopeInterface;



class Buyerprotect extends \Magento\Catalog\Model\Product\Type\AbstractType
{
    /**
     * Constant to get protuct type
     */
     const TYPE_BUYERPROTECT = 'buyerprotect';

     const TYPE_ID = 'buyerprotect';

    public function __construct(\Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig)
    {
        $this->_scopeConfig = $scopeConfig;
    }


    public function save($product)
    {
        parent::save($product);
        return $this;
    }


   
    protected static function _checkStockItem(\Magento\CatalogInventory\Model\Stock\Item $stockItem)
    {
        if ($stockItem->getUseConfigMaxSaleQty() != 0
            || $stockItem->getUseConfigMinSaleQty() != 0
            || $stockItem->getUseConfigManageStock() != 0
            || $stockItem->getManageStock()!= 0
           
            || $stockItem->getData('min_sale_qty') != 1
            || $stockItem->getMaxSaleQty() != 1
            ) {
            return false;
        }

        return true;
    }

   
    public function isVirtual($product = null)
    {
        // return True if this product is virtual and false if this product isn't virtual product
        return true;
    }


   
    public function deleteTypeSpecificData(\Magento\Catalog\Model\Product $product){
        return $this;
    }

   
    public function getAllTsProductIds($toArray = false)
    {
        $tsProducts = array();

       
       
       $tsProducts1 = $this->_scopeConfig->getValue('global/data/ts_products');
       $tsProd = array();
       $i=0;
       foreach($tsProducts1 as $key=>$val){
        
        $tsProd[] = (Object)$val;
       
       }

       $tsProducts[0] = $tsProd;
     
   
        $tsProducts = $tsProducts[0];

        return $toArray ? $tsProducts->asArray() : $tsProducts;
    }

    /**
     * Before save the product
     *
     * @param \Magento\Catalog\Model\Product $product product to save
     *
     * @return null
     */
    
 
    public function beforeSave($product = null)
    {

        parent::beforeSave($product);
        $product->setVisibility(1);
        
    }
  

   
    public static function checkStockItem(\Magento\CatalogInventory\Model\Stock\Item $stockItem)
    {
        if (!self::_checkStockItem($stockItem)) {
            $stockItem->setUseConfigMaxSaleQty(0);
            $stockItem->setUseConfigMinSaleQty(0);
            $stockItem->setUseConfigManageStock(0);
            $stockItem->setManageStock(0);
            $stockItem->setMinSaleQty(1);
            $stockItem->setMaxSaleQty(1);

            $stockItem->save();
        }

        return;
    }
}