<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Buyerprotect
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Buyerprotect\Model\System\Config\Source;


class Variation
{
    /**
     * @const CLASSIC_VALUE Value for classic option.
     */
    const CLASSIC_VALUE = 1;
    
    /**
     * @const EXCELLENCE_VALUE Value for excellence option.
     */
    const EXCELLENCE_VALUE = 2;
    
    /**
     * Generate option array for Trusted Shops product variation.
     *
     * @return array
     */
    public function toOptionArray()
    {
        $returnArray = array(
            array(
                'value' => self::CLASSIC_VALUE,
                'label' => __('Classic')
            ),

            array(
                'value' => self::EXCELLENCE_VALUE,
                'label' => __('Excellence')
            ),
        );

        return $returnArray;
    }
}