<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Buyerprotect
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Buyerprotect\Model\System\Config\Source;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Widget\Block\BlockInterface;

class Payments extends \Magento\Framework\View\Element\Template
{

    /**
     * @var \Magento\Payment\Helper\Data
     */
    protected $paymentHelper;

    public function __construct(
        \Magento\Payment\Helper\Data $paymentHelper
    ) {
        $this->paymentHelper = $paymentHelper;
    }
    /**
     * Get payment methods and add a dummy at the top.
     *
     * @return array
     */
    public function toOptionArray()
    {
      
        $methods = $this->paymentHelper->getPaymentMethodList();
        array_unshift(
            $methods,
            array(
                'value' => 'none',
                'label' => __('Not in use')
            )
        );
        return $methods;
    }
}