<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Buyerprotect
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Buyerprotect\Model;

class Setup 
{
    /*
     * Some constants for migration skripts.
     */
    const MIGRATION_TEMPLATE_PATH = '/app/locale/de_DE/migrations/';
    const MIGRATION_TEMPLATE_SUFFIX = '.html';

    /**
     * @var \Magento\Email\Model\TemplateFactory
     */
    protected $emailTemplateFactory;

    public function __construct(
        \Magento\Email\Model\TemplateFactory $emailTemplateFactory
    ) {
        $this->emailTemplateFactory = $emailTemplateFactory;
    }
    /**
     * Creates a new email template
     *
     * @param string $templateCode code/identifier of template
     * @param array  $content      index of 'template_subject' and 'template_text' are needed
     * @param int    $templateType 1|2 text|html email
     *
     * @return bool
     */
    public function createEmailTemplate($templateCode, array $content, $templateType = 2)
    {
        if (!isset ($content['template_subject']) || !isset ($content['template_text'])) {
            return false;
        }
      
        $emailTemplate = $this->emailTemplateFactory->create();
       
        if ($emailTemplate->loadByCode($templateCode)->hasData()) {
            return false;
        }
        $emailTemplate->setTemplateCode($templateCode)
            ->setTemplateSubject($content['template_subject'])
            ->setTemplateText($content['template_text'])
            ->setTemplateType($templateType)
            ->setAddedAt(new \Zend_Db_Expr('Now()'))
            ->setModifiedAt(new \Zend_Db_Expr('Now()'))
            ->save();

        return true;
    }

    /**
     * Updates an existing email template and create if neccessary
     *
     * @param string $templateCode code/identifier of template
     * @param array  $content      index of 'template_subject' and 'template_text' are needed
     *
     * @return bool
     */
    public function updateEmailTemplate($templateCode, array $content)
    {
        if (!isset ($content['template_subject']) || !isset ($content['template_text'])) {
            return false;
        }

        /* @var $emailTemplate Mage_Core_Model_Email_Template */
        $emailTemplate = $this->emailTemplateFactory->create();

        // Check if template exists
        // if not, create template
        if (!$emailTemplate->loadByCode($templateCode)->hasData()) {
            return $this->createEmailTemplate($templateCode, $content);
        }

        $emailTemplate->setTemplateCode($templateCode)
            ->setTemplateSubject($content['template_subject'])
            ->setTemplateText($content['template_text'])
            ->setModifiedAt(new \Zend_Db_Expr('Now()'))
            ->save();

        return true;
    }
}