<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Buyerprotect
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Buyerprotect\Model\Service\Soap;

class Data extends \Magento\Framework\DataObject
{
    /**
     *
     * @var \Magento\Sales\Model\Order
     */
    protected $_order = null;
    public function __construct(
        \Xtwo\Buyerprotect\Helper\Data $helper,
        \Magento\Framework\App\ProductMetadataInterface $productMetadata,
        array $data = []
    ) {

        $this->_helper = $helper;
        $this->productMetadata = $productMetadata;
        parent::__construct(
            $data
        );
    }


    public function init(\Magento\Sales\Model\Order $order, \Magento\Sales\Model\Order\Item $tsProductItem)
    {
        $this->setTsProductItem($tsProductItem);
        $this->setTsProductId($tsProductItem->getSku());
        $this->_order = $order;

        $this->_initTsSoapData();

        return $this;
    }
    protected function _initTsSoapData()
    {
      
        $order = $this->_order;
      
        $payment = $order->getPayment();
      
        $helper = $this->getHelper();

        $tsStoreConfigPaths = $helper->getTsStoreConfigPaths();
        $paymentCode = $payment->getMethod();
        $availableCodes = $helper->getAvailableTsPaymentCodes();
        $allTsProductTypes = $helper->getAllTsProductTypes();

        $this->setAvailablePaymentCodes($availableCodes);

        if (!is_array($availableCodes) || !array_key_exists($paymentCode, $availableCodes)) {
            throw new \Exception($paymentCode.' is not a supported payment by Trusted Shops!');
        
        }
      
        if (!in_array($this->getTsProductItem()->getProductId(), $allTsProductTypes)) {
          
           throw new \Exception($this->getTsProductId().' is not a valid TS product type');
        }

        $tsSoapData = array(
            'is_active' => $helper->getStoreConfig($tsStoreConfigPaths['is_active']),
            'ts_id' => $helper->getStoreConfig($tsStoreConfigPaths['ts_id']),
            'ws_user' => $helper->getStoreConfig($tsStoreConfigPaths['ws_user']),
            'ws_password' => $helper->getStoreConfig($tsStoreConfigPaths['ws_password']),
            'wsdl_url' => $helper->getWsdlUrl(),
            'buyer_email' => $order->getCustomerEmail(),
            'amount' => $order->getGrandTotal(),
            'shop_order_id' => $order->getRealOrderId(),
            'order_date' => $this->getTsOrderDate($order->getCreatedAt()),
            'payment_type' => $this->getPaymentMethodByCode($paymentCode),
            'ts_product_id' => $this->getTsProductId(),
            'currency' => $helper->getCurrencyCode(),
            'shop_customer_id' => $order->getCustomerId()
        );

        $this->setData($tsSoapData);

        return;
    }

    /**
     * Returns an TS array whith formated keys.
     * 11 required fields for TS SOAP service. Note the format of the keys.
     *
     * @see self::_initTsSoapData()
     * @return array
     */
    public function getTsSoapData()
    {
        if (!($formatedTsSoapData = $this->getFormatedTsSoapData())) {
            $formatedTsSoapData = array(
                'tsId' => $this->getTsId(),
                'tsProductId' => $this->getTsProductId(),
                'amount' => $this->getAmount(),
                'currency' => $this->getCurrency(),
                'paymentType' => $this->getPaymentType(),
                'buyerEmail' => $this->getBuyerEmail(),
                'shopCustomerID' => $this->getShopCustomerId(),
                'shopOrderID' => $this->getShopOrderId(),
                'oderDate' => $this->getOrderDate(),
                'shopSystemVersion' => $this->getShopSystemVersion(),
                'wsUser' => $this->getWsUser(),
                'wsPasssword' => $this->getWsPassword()
            );

            $this->setFormatedTsSoapData($formatedTsSoapData);
        }

        return $formatedTsSoapData;
    }

    /**
     * Returns a TS formated date time:
     *
     * 2010-10-10T10:10:10
     *
     * @param string $dateTime Order date
     *
     * @return string
     */
    public function getTsOrderDate($dateTime)
    {
        return str_replace(' ', 'T', $dateTime);
    }

    /**
     * Returns the payment method
     *
     * @param string $paymentCode Payment code
     * 
     * @return string
     */
    public function getPaymentMethodByCode($paymentCode)
    {
        if (!($availableCodes = $this->getAvailablePaymentCodes())) {
            $availableCodes = $this->getHelper()->getAvailableTsPaymentCodes();
        }

        return $availableCodes[$paymentCode];
    }

    /**
     * Returns helper object
     *
     * @return Xtwo_Buyerprotect_Helper_Data
     */
    public function getHelper()
    {
        if (!($helper = $this->getData('helper'))) {
            $helper = $this->_helper;

            $this->setHelper($helper);
        }

        return $helper;
    }

    /**
     * URL of SOAP server      
     *                     
     * @param string $type SOAP API type [backend|frontend].                    
     *                     
     * @return string
     */
    public function getWsdlUrl($type = 'backend')
    {
        return $this->getHelper()->getWsdlUrl($type);
    }

    /**
     * Get Magento version.
     *
     * @return string
     */
    public function getMagentoVersion()
    {
       // return \Magento\Framework\App\ProductMetadata->getVersion();
        return $this->productMetadata->getVersion();
    }

    /**
     * Get module version
     *
     * @return string
     */
    public function getModulVersion()
    {
        
        $name = \Xtwo\Buyerprotect\Helper\Data::BUYERPROTECT_MODUL_NAME;

       return '0.5.2';
    }

    /**
     * Get both versions: Magento and module. It's for requestForProtectionV2().
     *
     * @return string
     */
    public function getShopSystemVersion()
    {
        if (!($version = $this->getData('shop_system_version'))) {
            $version  = 'Magento ' . $this->getMagentoVersion() . ' - '
                      . 'MC Trusted Shops Käuferschutz ' . $this->getModulVersion();
            
            $this->setData('shop_system_version', $version);
        }

        return $version;
    }

    /**
     * Check service is active
     *
     * @return bool
     */
    public function isActive()
    {
        return (bool) $this->getIsActive();
    }
}