<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Buyerprotect
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */
 
namespace Xtwo\Buyerprotect\Model\Service;


class Soap
{
    /**
     * Constant to define $_requestErrorCode on exception.
     *
     * @todo in v2 0 is used by Trusted Shops
     */
    const TS_SOAP_EXCEPTION_CODE = -9999;

    /**
     * Do not set positive values on error!
     * The Trusted Shop API returns a positive value on success.
     *
     * @var int|null
     */
    protected $_requestErrorCode = null;

    /**
     * Log file name.
     *
     * @var string
     */
    protected $_buyerProtectLogFile = 'ts_buyerprotect.log';

    /**
     * Optional order object, if requestForProtection() is called later without
     * order as an param.
     *
     * @var \Magento\Sales\Model\Order
     */
    protected $_order = null;       
    
    /**
     * Order id in case requestForProtection() is called later.
     *
     * @var int
     */
    protected $_orderId = null;

    /**
     * @var \Psr\Log\LoggerInterface
     */
    protected $logger;

    /**
     * @var \Magento\Sales\Model\OrderFactory
     */
    protected $salesOrderFactory;

    public function __construct(
        \Psr\Log\LoggerInterface $logger,
        \Magento\Sales\Model\OrderFactory $salesOrderFactory,
        \Xtwo\Buyerprotect\Helper\Data $helper,
        \Xtwo\Buyerprotect\Model\Service\Soap\Data $soapdata
    ) {
        $this->logger = $logger;
        $this->salesOrderFactory = $salesOrderFactory;
        $this->_helper = $helper;
        $this->_soapdata = $soapdata;
    }
    /**
     * Check certificate status.
     * 
     * SUPTRUSTEDSHOPS-57: Added possibility to pass TS ID to check for.
     * 
     * @param string $tsId Trustedshops ID of certification
     *
     * @return array
     */
    public function checkCertificate($tsId = null)
    {
    
        $helper = $this->_helper;
        $wsdl = $helper->getWsdlUrl('backend');
        
        if (!$tsId) {
            $tsId = $helper->getTsUserId();
        }
        
        $soapClient = new \SoapClient($wsdl);
        
        $tsData = $soapClient->checkCertificate($tsId);

   

       if(!$tsData->stateEnum == 'INVALID_TS_ID'){
        
        return array(
            'language' => $tsData->certificationLanguage,
            'variation' => $tsData->typeEnum,
            'state' => $tsData->stateEnum
        );  
       }
       else {
        return array(            
            'variation' => $tsData->typeEnum,
            'state' => $tsData->stateEnum
        );  
       }       
    }
    
   
    protected function _request(\Xtwo\Buyerprotect\Model\Service\Soap\Data $buyerprotectModul)
    {
        $soapClient = new \SoapClient($buyerprotectModul->getWsdlUrl());

        $this->_requestErrorCode = $soapClient->requestForProtection(
            $buyerprotectModul->getTsId(),
            $buyerprotectModul->getTsProductId(),
            $buyerprotectModul->getAmount(),
            $buyerprotectModul->getCurrency(),
            $buyerprotectModul->getPaymentType(),
            $buyerprotectModul->getBuyerEmail(),
            $buyerprotectModul->getShopCustomerId(),
            $buyerprotectModul->getShopOrderId(),
            $buyerprotectModul->getOrderDate(),
            $buyerprotectModul->getWsUser(),
            $buyerprotectModul->getWsPassword()
        );

        return;
    }

   
    protected function _requestV2(\Xtwo\Buyerprotect\Model\Service\Soap\Data $buyerprotectModul)
    {                                                               
        $soapClient = new \SoapClient($buyerprotectModul->getWsdlUrl('frontend'));

        $this->_requestErrorCode = $soapClient->requestForProtectionV2(
            $buyerprotectModul->getTsId(),
            $buyerprotectModul->getTsProductId(),
            $buyerprotectModul->getAmount(),
            $buyerprotectModul->getCurrency(),
            $buyerprotectModul->getPaymentType(),
            $buyerprotectModul->getBuyerEmail(),
            $buyerprotectModul->getShopCustomerId(),
            $buyerprotectModul->getShopOrderId(),
            $buyerprotectModul->getOrderDate(),
            $buyerprotectModul->getShopSystemVersion(),
            $buyerprotectModul->getWsUser(),
            $buyerprotectModul->getWsPassword()
        );

        return;
    }

    /**
     * Validation if item is set.
     *
     * @param object $tsItem An item object.
     *
     * @return void
     */
    private function checkIfTsItemIsSet($tsItem)
    {
        if (!$tsItem) {
            $this->logger->debug("$tsItem is empty!");
        }
    }
    
   
    public function requestForProtection(\Magento\Sales\Model\Order $order = null)
    {
        if (!$order && !$this->_order) {
            $this->logger->debug('Order object not set!');
            return;
        }

        if (!$order) {
            $order = $this->_order;
        } else {
            $this->_order = $order;
        }

        $orderItemsCollection = clone $order->getItemsCollection();
      

        $orderItemsCollection->addFieldToFilter('product_type', array('eq' => 'buyerprotect'));

        
        if ($orderItemsCollection->count() >= 1) {
            $tsItem = null;
      
            foreach ($orderItemsCollection->getItems() as $item) {
              
                    $tsItem = $item;
              
            }
            $this->checkIfTsItemIsSet($tsItem);

            $tsSoapDataObject = $this->_soapdata;
            // have doubt on init funcion here
           // return null added by prm since payone is not working
           // return null;

           $payment = $order->getPayment();
            $method = $payment->getMethodInstance();
            $methodTitle = $method->getCode();

            $this->logger->debug('end SOAP request111:'.$methodTitle);
            // if($methodTitle != 'payone_creditcard'){
                        $tsSoapDataObject->init($order, $tsItem);

                        if ($tsSoapDataObject->isActive()) {
                            try {
                                $this->_requestV2($tsSoapDataObject);
                            $this->logger->log(0, 'SOAP return value: '.$this->_requestErrorCode);
                                $this->logger->log(0, 'SOAP request successful.');
                            } catch (SoapFault $soapFault) {
                                $this->_requestErrorCode = self::TS_SOAP_EXCEPTION_CODE;
                                $this->logger->log(0, 'SOAP request failed! See exception log!');
                                $this->logger->critical($soapFault);
                            } 
                            
                            $this->logger->log(0, implode(" ",$tsSoapDataObject->getTsSoapData()));
                        }

                        return $tsSoapDataObject;
          // }
    }

        return null;
    }
                 
    /**                                                                            
     * Load Order object, using in advance established order id.
     *
     * @return \Magento\Sales\Model\Order
     */                                                              
    public function loadOrder()
    {
        if (is_null($this->_order)) {
            $this->_order = $this->salesOrderFactory->create()->load($this->_orderId);
        }

        return $this->_order;
    }

    /**
     * Set order id in case requestForProtection() is called later.
     *
     * @param int $orderId Order id.
     *
     * @return Xtwo_Buyerprotect_Model_Service_Soap
     */
    public function setOrderId($orderId)
    {
        $this->_orderId = $orderId;

         return $this;
    }
}