<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Buyerprotect
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Buyerprotect\Model;


class Products extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * Default ignored attribute codes
     *
     * @var array
     */
    protected $_ignoredAttriCodes = array('entity_id', 'attribute_set_id', 'entity_type_id');

    /**
     * Default ignored attribute types
     *
     * @var array
     */
    protected $_ignoredAttriTypes = array();

    /**
     * @var \Magento\Store\Model\StoreFactory
     */
    protected $storeStoreFactory;

    /**
     * @var \Magento\Store\Model\WebsiteFactory
     */
    protected $storeWebsiteFactory;

    /**
     * @var \Magento\Catalog\Model\ProductFactory
     */
    protected $catalogProductFactory;

    /**
     * @var \Psr\Log\LoggerInterface
     */
    protected $logger;

    /**
     * @var \Magento\CatalogInventory\Model\Stock\ItemFactory
     */
    protected $catalogInventoryStockItemFactory;

    /**
     * @var \Magento\Framework\App\ResourceConnection
     */
    protected $resourceConnection;

    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        \Magento\Store\Model\StoreFactory $storeStoreFactory,
        \Magento\Store\Model\WebsiteFactory $storeWebsiteFactory,
        \Magento\Catalog\Model\ProductFactory $catalogProductFactory,
        \Psr\Log\LoggerInterface $logger,
        \Magento\CatalogInventory\Model\Stock\ItemFactory $catalogInventoryStockItemFactory,
        \Magento\CatalogInventory\Model\ResourceModel\Stock\ItemFactory $itemfactory,
        \Magento\Framework\App\ResourceConnection $resourceConnection,
        \Xtwo\Buyerprotect\Helper\Data $buyerprotect,
        \Magento\Store\Model\ResourceModel\Website\CollectionFactory $websiteCollectionFactory,
        \Xtwo\Buyerprotect\Model\Type\Buyerprotect $buyerprotecttype,
        \Magento\CatalogInventory\Api\StockRegistryInterface $stockRegistry
    ) {
        $this->stockRegistry = $stockRegistry;
        $this->storeStoreFactory = $storeStoreFactory;
        $this->storeWebsiteFactory = $storeWebsiteFactory;
        $this->catalogProductFactory = $catalogProductFactory;
        $this->logger = $logger;
        $this->catalogInventoryStockItemFactory = $catalogInventoryStockItemFactory;
        $this->resourceConnection = $resourceConnection;
        $this->buyerprotect = $buyerprotect;
        $this->_websiteCollectionFactory = $websiteCollectionFactory;
        $this->buyerprotecttype = $buyerprotecttype;
        $this->itemfactory = $itemfactory;
        parent::__construct(
            $context
        );
    }

    public function getWebsiteCollection()
    {
        $collection = $this->_websiteCollectionFactory->create();
        return $collection;
    }


    /**
     * Get scope from post data.
     *
     * @param string $website Current website scope.
     * @param string $store   Current store scope.
     *
     * @return array
     */
    public function getScopeId($website, $store)
    {
        if (!empty($store)) {
            $scope['type'] = 'stores';
            $scope['id'] = $this->storeStoreFactory->create()->load($store, 'code')->getId();
        } elseif (!empty($website)) {
            $scope['type'] = 'websites';
            $scope['id'] = $this->storeWebsiteFactory->create()->load($website, 'code')->getId();
        } else {
            $scope['type'] = 'default';
            $scope['id'] = 0;
        }
        return $scope;
    }

    /**
     * Recreate Trusted Shops Excellence Buyer Protection products.
     *
     * @param bool   $deleteOld Delete old products or check if there are already products?
     * @param string $website   Current website scope.
     * @param string $store     Current store scope.
     *
     * @return void
     */
    public function recreateProducts($deleteOld, $website, $store)
    {
        // todo: implement translations according to the result of this method
        //       or something.
        $this->getScopeId($website, $store);

       // $helper = Mage::helper('buyerprotect');
        $helper = $this->buyerprotect;
        $productCollection = $helper->getAllTsProducts();

        if ($deleteOld) {
            $createNew = $this->deleteProducts($productCollection);
        } else {
            $createNew = true;
        }
        if ($createNew) {
            $this->createProducts();
        }
    }

    /**
     * Create a specific TS product.
     *
     * @return void
     */
    public function createProducts()
    {
      
       $tsProductsIds =$this->buyerprotecttype->getAllTsProductIds();
       $tsProductsData = array();
        $preTaxValue = 1.19;
        $currency = new \Zend_Currency('de_DE');
        foreach ($tsProductsIds as $tsProduct) {
            $tsProductsData['price'] = (double) $tsProduct->net * (double) $preTaxValue;
            preg_match('/^TS080501_([0-9]*)_.*/', $tsProduct->id, $matches);
            $tsProductName = "Käuferschutz bis " . $currency->toCurrency($matches[1]);
            $tsProductsData['name'] = $tsProductName;
            $tsProductsData['description'] = $tsProductName . $currency->toCurrency($tsProductsData['price']);
            $tsProductsData['short_description'] = $tsProductName . $currency->toCurrency($tsProductsData['price']);
            
              
            $this->createBuyerprotectProduct($tsProduct->id, $tsProductsData);
        }
    }

   
    public function deleteProducts($productCollection)
    {
        foreach ($productCollection as $product) {
            $product->delete();
        }
    }

    /**
     * Create a BuyerProtect product from given data.
     *
     * @param string $sku         sku for new product
     * @param array  $productData Required indexes:
     *                            $productData['price'] (pre-tax)
     *                            $productData['name']
     *                            $productData['description']
     *                            $productData['short_description']
     *
     * @return void
     */
    public function createBuyerprotectProduct($sku, $productData)
    {
        $defaultSetId = $this->getDefaultAttributeSetId('catalog_product');
        $productModel = $this->catalogProductFactory->create();
       
       
        if ($productModel->getIdBySku($sku)) {
           return;
        
        }
       

        $productModel->setStoreId(0)
            ->setWebsiteIds($this->_getWebsiteIds())
            ->setAttributeSetId($defaultSetId)
            ->setTypeId('buyerprotect')
            ->setStatus(1)
            ->setSku($sku);

        foreach ($productModel->getTypeInstance(true)->getEditableAttributes($productModel) as $attribute) {
            $_attrCode = $attribute->getAttributeCode();
            if ($this->_isAllowedAttribute($attribute) && isset($productData[$_attrCode])) {
                $productModel->setData(
                    $attribute->getAttributeCode(),
                    $productData[$_attrCode]
                );
            }
        }

        $errors = $productModel->validate();
        if (is_array($errors)) {
            return $errors;
        }

        $stockData = array();
        $stockData['use_config_manage_stock'] = 0;
        $stockData['manage_stock'] = 0;
        $productModel->setStockData($stockData);

        try {
            $productModel->save();
        } catch (Exception $e) {
            $this->logger->critical($e);
        }

        /**************
         * stock part *
         **************/

       

        $stockItem = $this->stockRegistry->getStockItem($productModel->getId());
        $stockItem->setProductId($productModel->getId());
        $stockItem->setStockId(\Magento\CatalogInventory\Model\Stock::DEFAULT_STOCK_ID);
        $stockItem->setQty(999999999999);
        $stockItem->setIsInStock(1);
        $stockItem->setMinSaleQty(1);
        $stockItem->setMaxSaleQty(1);

       // $stockItem->setUseConfigManageStock(0);
      //  $stockItem->setManageStock(0);

        // done by prm set to 1
        $stockItem->setUseConfigManageStock(0);
        $stockItem->setManageStock(0);  

        try {
            $stockItem->save();
        } catch (Exception $e) {
            $this->logger->critical($e);
        }

        return;
    }


    /**
     * Retrieve Default Attribute Set for Entity Type
     *
     * @param string|int $entityType Attribute set type.
     *
     * @return int
     */
    public function getDefaultAttributeSetId($entityType)
    {
        $resource = $this->resourceConnection;
        $connection = $resource->getConnection('core/read');
        $select = $connection->select()
            ->from($resource->getTableName('eav_entity_type'), 'default_attribute_set_id')
            ->where(is_numeric($entityType) ? 'entity_type_id=?' : 'entity_type_code=?', $entityType);
        return $resource->getConnection('core/read')->fetchOne($select);
    }

    /**
     * Get all website IDs.
     *
     * @return array
     */
    protected function _getWebsiteIds()
    {

        foreach($this->getWebsiteCollection() as $website) {
       
           $id[] = $website->getId();
        }

        return $id;

        
    }

    /**
     * Check is attribute allowed
     *
     * @param \Magento\Eav\Model\Entity\Attribute\AbstractAttribute $attribute  attribute to check
     * @param array                                    $attributes array of attributes
     *
     * @return boolean
     */
    protected function _isAllowedAttribute($attribute, $attributes = null)
    {
        if (is_array($attributes)
            && !( in_array($attribute->getAttributeCode(), $attributes)
                  || in_array($attribute->getAttributeId(), $attributes))) {
            return false;
        }

        return !in_array($attribute->getFrontendInput(), $this->_ignoredAttriTypes)
               && !in_array($attribute->getAttributeCode(), $this->_ignoredAttriCodes);
    }
}