<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Buyerprotect
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Buyerprotect\Model\Observer;

use Magento\Framework\Event\Observer as EventObserver;
use Magento\Framework\Event\ObserverInterface;

class requestTsProtection implements ObserverInterface
{

    /**
     * @var \Magento\Checkout\Model\Cart
     */
    protected $checkoutCart;

    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $storeManager;

    /**
     * @var \Magento\Catalog\Model\ProductFactory
     */
    protected $catalogProductFactory;

    /**
     * @var \Magento\Framework\Event\ManagerInterface
     */
    protected $eventManager;

    /**
     * @var \Magento\Customer\Model\Session
     */
    protected $customerSession;

    /**
     * @var \Psr\Log\LoggerInterface
     */
    protected $logger;

    /**
     * @var \Magento\Framework\App\Request\Http
     */
    protected $request;

    /**
     * @var \Magento\Store\Model\StoreFactory
     */
    protected $storeStoreFactory;

    /**
     * @var \Magento\Store\Model\WebsiteFactory
     */
    protected $storeWebsiteFactory;

    /**
     * @var \Magento\Framework\Session\Generic
     */
    protected $generic;

    public function __construct(
      
        \Magento\Customer\Model\Session $customerSession,
        \Psr\Log\LoggerInterface $logger,      
        \Xtwo\Buyerprotect\Helper\Data $helper,       
        \Xtwo\Buyerprotect\Model\Service\Soap $soap      
    ) {         
        $this->customerSession = $customerSession;
        $this->logger = $logger;
        $this->_helper = $helper;       
        $this->soap = $soap;
    }
    
    /**
     * Request for buyer protection service of Trusted Shops if
     * Xtwo_Buyerprotect_Model_Service_Soap is in customer session on
     * checkout success.
     *
     * @return void
     */
    public function execute(EventObserver $observer)
    {
       
        $this->registerTsSoapModel($observer);

        
        $customerSession = $this->customerSession;
     
        if ($customerSession->getTsSoap()) {
            $tsSoap = $this->soap;
            $tsSoap->setOrderId($customerSession->getOrderId());

            $tsSoap->loadOrder();
            try {
                $this->logger->debug('start SOAP request');
                $order = $observer->getEvent()->getOrder();

                $payment = $order->getPayment();
                $method = $payment->getMethodInstance();
                $methodTitle = $method->getTitle();
    
                $this->logger->debug('end SOAP request:'.$methodTitle);

                $tsSoap->requestForProtection($order);
               // echo "after requestForProtection";
                $this->logger->debug('end SOAP request');
                
            } catch (Exception $e) {
                $this->logger->log(null, 'SOAP request failed! See exception log!');
                $this->logger->critical($e);
            }
        }
    }

    public function registerTsSoapModel($observer)
    {
        $helper = $this->_helper;
        if ($helper->hasTsProductsInCart()) {
            $order = $observer->getEvent()->getOrder();           
            $this->customerSession->setTsSoap(1);          
            $this->customerSession->setOrderId($order->getId());
        }
    }
}