<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Buyerprotect
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Buyerprotect\Model\Observer;

use Magento\Framework\Event\ObserverInterface;

class hookIntoCataloginventoryStockItemSaveAfter implements ObserverInterface
{

    /**
     * @var \Magento\Checkout\Model\Cart
     */
    protected $checkoutCart;

    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $storeManager;

    /**
     * @var \Magento\Catalog\Model\ProductFactory
     */
    protected $catalogProductFactory;

    /**
     * @var \Magento\Framework\Event\ManagerInterface
     */
    protected $eventManager;

    /**
     * @var \Magento\Customer\Model\Session
     */
    protected $customerSession;

    /**
     * @var \Psr\Log\LoggerInterface
     */
    protected $logger;

    /**
     * @var \Magento\Framework\App\Request\Http
     */
    protected $request;

    /**
     * @var \Magento\Store\Model\StoreFactory
     */
    protected $storeStoreFactory;

    /**
     * @var \Magento\Store\Model\WebsiteFactory
     */
    protected $storeWebsiteFactory;

    /**
     * @var \Magento\Framework\Session\Generic
     */
    protected $generic;

    

    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $stockItem = $observer->getEvent()->getItem();
       

        if (!$stockItem) {
            return;
        }

        $typeIdentifier = $stockItem->getProductTypeId();

        if ($typeIdentifier == \Xtwo\Buyerprotect\Model\Type\Buyerprotect::TYPE_BUYERPROTECT) {
            \Xtwo\Buyerprotect\Model\Type\Buyerprotect::checkStockItem($stockItem);
        }

        return;
    }

    
}