<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Buyerprotect
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Buyerprotect\Model\Observer;

use Magento\Framework\Event\ObserverInterface;

class checkCertificate implements ObserverInterface
{

    /**
     * @var \Magento\Checkout\Model\Cart
     */
    protected $checkoutCart;

    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $storeManager;

    /**
     * @var \Magento\Catalog\Model\ProductFactory
     */
    protected $catalogProductFactory;

    /**
     * @var \Magento\Framework\Event\ManagerInterface
     */
    protected $eventManager;

    /**
     * @var \Magento\Customer\Model\Session
     */
    protected $customerSession;

    /**
     * @var \Psr\Log\LoggerInterface
     */
    protected $logger;

    /**
     * @var \Magento\Framework\App\Request\Http
     */
    protected $request;

    /**
     * @var \Magento\Store\Model\StoreFactory
     */
    protected $storeStoreFactory;

    /**
     * @var \Magento\Store\Model\WebsiteFactory
     */
    protected $storeWebsiteFactory;

    /**
     * @var \Magento\Framework\Session\Generic
     */
    protected $generic;

    public function __construct(
     
        \Psr\Log\LoggerInterface $logger,
        \Magento\Framework\App\Request\Http $request,
        \Magento\Store\Model\StoreFactory $storeStoreFactory,
        \Magento\Store\Model\WebsiteFactory $storeWebsiteFactory,
        \Magento\Framework\Session\Generic $generic,
        \Xtwo\Buyerprotect\Helper\Data $helper,     
        \Xtwo\Buyerprotect\Model\Service\Soap $soap,
        \Xtwo\Buyerprotect\Model\ProductsFactory $product,
        \Magento\Framework\Message\ManagerInterface $messageManager
    ) {
      
     
     
        $this->logger = $logger;
        $this->request = $request;
        $this->storeStoreFactory = $storeStoreFactory;
        $this->storeWebsiteFactory = $storeWebsiteFactory;
        $this->generic = $messageManager;
        $this->generic1 = $generic;
        $this->_helper = $helper;       
        $this->soap = $soap;
        $this->product = $product;
      
   
    }
  
    /**
     * Check certificate status.
     * admin_system_config_changed_section_buyerprotection
     *
     * @param \Magento\Framework\Event\Observer $observer Varien observer object.
     *
     * @return void
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $params = $this->request->getParams();
        if (isset($params['groups']['data']['fields']['trustedshops_id']['value'])) {
            $tsId = trim($params['groups']['data']['fields']['trustedshops_id']['value']);
        }
        if (!isset($tsId) || is_null($tsId)) {
            return;
        }
       // $helper = Mage::helper('buyerprotect');
       $helper = $this->_helper;
        $website = $observer->getWebsite();
        $store = $observer->getStore();

        if (!empty($store)) {
            $scope = 'stores';
            $scopeId = $this->storeStoreFactory->create()->load($store, 'code')->getId();
        } elseif (!empty($website)) {
            $scope = 'websites';
            $scopeId = $this->storeWebsiteFactory->create()->load($website, 'code')->getId();
        } else {
            $scope = 'default';
            $scopeId = 0;
        }
        $pattern = '!^X[A-Za-z0-9]{32}$!imsU';
        if (!preg_match($pattern, $tsId)) {
            $this->generic->addNotice(
                __('Invalid Trusted Shops ID. Disabled buyer protection.')
            );

            $helper->setConfigData(
                \Xtwo\Buyerprotect\Helper\Data::XML_PATH_TS_BUYERPROTECT_IS_ACTIVE,
                0,
                $scope,
                $scopeId
            );
        } else {
         
            $tsData = $this->soap->checkCertificate($tsId);
            // ADDED BY ME
            if($tsData['variation'] != 'INVALID_TS_ID ' && $tsData['state'] != 'INVALID_TS_ID'){

                  

                    if ($tsData['variation'] == 'CLASSIC') {
                        $variation = \Xtwo\Buyerprotect\Model\System\Config\Source\Variation::CLASSIC_VALUE;
                    } else {
                        $variation = \Xtwo\Buyerprotect\Model\System\Config\Source\Variation::EXCELLENCE_VALUE;
                    // $productsModel = Mage::getModel('buyerprotect/products');
                        $productsModel = $this->product->create();
                        $productsModel->recreateProducts(false, $website, $store);
                    }

                    $helper->setConfigData(
                        \Xtwo\Buyerprotect\Helper\Data::XML_PATH_TS_BUYERPROTECT_VARIATION,
                        $variation,
                        $scope,
                        $scopeId
                    );

        }
   
   

            $notice = __(
                'Checking Trusted Shops ID: %s | Buyer Protection version: %s',
                $tsId,
                $tsData['variation']
            );
            $this->generic->addNotice($notice);
        }
    }
}