<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Buyerprotect
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Buyerprotect\Model\Observer;

use Magento\Framework\Event\ObserverInterface;
class addProductToCart implements ObserverInterface
{

    /**
     * @var \Magento\Checkout\Model\Cart
     */
    protected $checkoutCart;

    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $storeManager;

    /**
     * @var \Magento\Catalog\Model\ProductFactory
     */
    protected $catalogProductFactory;

    /**
     * @var \Magento\Framework\Event\ManagerInterface
     */
    protected $eventManager;

    /**
     * @var \Magento\Customer\Model\Session
     */
    protected $customerSession;

    /**
     * @var \Psr\Log\LoggerInterface
     */
    protected $logger;

    /**
     * @var \Magento\Framework\App\Request\Http
     */
    protected $request;

    /**
     * @var \Magento\Store\Model\StoreFactory
     */
    protected $storeStoreFactory;

    /**
     * @var \Magento\Store\Model\WebsiteFactory
     */
    protected $storeWebsiteFactory;

    /**
     * @var \Magento\Framework\Session\Generic
     */
    protected $generic;

    

  
    public function __construct(
        \Magento\Checkout\Model\Cart $checkoutCart,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Catalog\Model\ProductFactory $catalogProductFactory,
        \Magento\Framework\Event\ManagerInterface $eventManager,
        \Magento\Customer\Model\Session $customerSession,
        \Psr\Log\LoggerInterface $logger,
        \Magento\Framework\App\Request\Http $request,
        \Magento\Store\Model\StoreFactory $storeStoreFactory,
        \Magento\Store\Model\WebsiteFactory $storeWebsiteFactory,
        \Magento\Framework\Session\Generic $generic,
        \Xtwo\Buyerprotect\Helper\Data $helper,
        \Magento\Framework\App\RequestInterface $req,
        \Xtwo\Buyerprotect\Model\Service\Soap $soap,
        \Xtwo\Buyerprotect\Model\ProductsFactory $product,
    ) {
        $this->checkoutCart = $checkoutCart;
        $this->storeManager = $storeManager;
        $this->catalogProductFactory = $catalogProductFactory;
        $this->eventManager = $eventManager;
        $this->customerSession = $customerSession;
        $this->logger = $logger;
        $this->request = $request;
        $this->storeStoreFactory = $storeStoreFactory;
        $this->storeWebsiteFactory = $storeWebsiteFactory;
        $this->generic = $generic;
        $this->_helper = $helper;
        $this->req =  $req;
        $this->soap = $soap;
        $this->product = $product;
   
    }
  
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $request =  $this->req->getParams();
        $cart = $this->checkoutCart->setStore($this->storeManager->getStore());
        $helper = $this->_helper;
        if ($this->req->has('trusted_shops')) {
            $this->logger->info("got from obserer trusted_shops.");
            $tsProductsInCart = $helper->getTsProductsInCart();
            if ($request->getParam('trusted_shops')) {
                // cart is empty
                if (!($cartProductIds = $cart->getProductIds())) {
                    return;
                }
                $requestedProductId = $request->getParam('trusted_shops-product');
                if ((count($cartProductIds) < 2) && in_array($requestedProductId, $cartProductIds)) {
                    return;
                }
                if ($tsProductsInCart) {
                    foreach ($tsProductsInCart as $cartItemId => $tsProductId) {
                        $cart->removeItem($cartItemId);
                    }
                }
                // add Buyerprotection Product to cart
                $cart->addProductsByIds(array($requestedProductId));
                $this->_saveCart($cart);

            } else {
                if ($tsProductsInCart) {
                    foreach ($tsProductsInCart as $cartItemId => $tsProductId) {
                        $cart->removeItem($cartItemId);
                    }
                }
            }

        } elseif ($this->req->has('insurance')) {
            $insuranceHelper = $this->helper;
            $insuranceQuoteItems = $insuranceHelper->getInsuranceProductsInCart();
            if ($request->getParam('insurance')) {
                // Cart is empty
                if (!($cartProductIds = $cart->getProductIds())) {
                    return;
                }
                $requestedProductId = $request->getParam('insurance-product');

                if ((count($cartProductIds) < 2) && in_array($requestedProductId, $cartProductIds)) {
                    return;
                }

                if ($insuranceQuoteItems) {
                    foreach ($insuranceQuoteItems as $quoteItem) {
                        $cart->removeItem($quoteItem->getId());
                    }
                }
                // Add Buyerprotection Product to cart
                $product = $this->_getProduct($requestedProductId);

                $canAdd = true;
                // In case of a dynamic product price of insurance we set it now
                if ($insuranceHelper->isDynamicActive($product->getStore())
                            && !$insuranceHelper->setDynamicPrice($product, $cart)) {
                    $canAdd = false;
                }

                if ($canAdd) $cart->addProduct($product);
                $this->_saveCart($cart);

            } else {

                if ($insuranceQuoteItems) {
                    foreach ($insuranceQuoteItems as $quoteItem) {
                        $cart->removeItem($quoteItem->getId());
                    }
                }
            }
        }
        $this->logger->info("last...............");
        return;
    }

   
    private function _saveCart($cart)
    {
        $cart->getQuote()->getBillingAddress();
        $cart->getQuote()->getShippingAddress()->setCollectShippingRates(true);
        $cart->getQuote()->save();
        $cart->getCheckoutSession()->setQuoteId($cart->getQuote()->getId());
       
        $this->eventManager->dispatch('checkout_cart_save_after', array('cart' => $cart));
    }

   
}