<?php

namespace Xtwo\Buyerprotect\Model\Observer;

use Magento\Framework\Event\ObserverInterface;
class AdminProductSaveAfterObserver implements ObserverInterface
{
    /**
     * @var \Magento\Framework\Indexer\IndexerRegistry
     */
    protected $indexerRegistry;
    /**
     * Object intialization
     *
     * @param \Magento\Framework\Indexer\IndexerRegistry $indexerRegistry
     */
    public function __construct(
        \Magento\Framework\Indexer\IndexerRegistry $indexerRegistry
    ) {
        $this->indexerRegistry = $indexerRegistry;
    }
    
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        try {
            $product = $observer->getProduct();
            if (!empty($product)) {
                $productIds = [$product->getId()]; //here you can one or more product Ids in array
                //list of indexers
                $indexList = [
                    'catalog_category_product',
                    'catalog_product_category',
                    'catalog_product_attribute',
                    'cataloginventory_stock',
                    'inventory',
                    'catalogsearch_fulltext',
                    'catalog_product_price',
                    'catalogrule_product',
                    'catalogrule_rule'
                ];
 
                foreach ($indexList as $index) {
                    $categoryIndexer = $this->indexerRegistry->get($index);
                
                    //check is indexer is scheduled
                    if (!$categoryIndexer->isScheduled()) {
                        $categoryIndexer->reindexList($productIds);
                    }
                }
            }
        } catch (\Exception $e) {
            echo $e->getMessage();
        }
    }
}