<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Buyerprotect
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */


namespace Xtwo\Buyerprotect\Model\Config\Source;
use Magento\Framework\Escaper;
use Magento\Store\Model\System\Store as SystemStore;


class Stores implements \Magento\Framework\Option\ArrayInterface
{

    /**
     * Escaper
     *
     * @var Escaper
     */
    protected $escaper;

    /**
     * System store
     *
     * @var SystemStore
     */
    protected $systemStore;

    /**
     * Constructor
     *
     * @param SystemStore $systemStore
     * @param Escaper $escaper
     */
    public function __construct(SystemStore $systemStore, Escaper $escaper)
    {
        $this->systemStore = $systemStore;
        $this->escaper = $escaper;
    }
    


   public function toOptionArray()
   {
      $options = array();
       $options[] = ['label' => __('---- All Store Views ----'),  'value' => 0, 'optgroup' => [] ];

       $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
       $storeManager = $objectManager->get('Magento\Store\Model\StoreManagerInterface');

       $storeManagerDataList = $storeManager->getStores();
     

        foreach ($storeManagerDataList as $key => $value)
        {
              $options[] = ['label' => $value['name'],  'value' => $key ];
        }
        return $options;
   }

}