<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Buyerprotect
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Buyerprotect\Model;


class Buyerprotection extends \Magento\Framework\Model\AbstractModel
{
    /**
     * Email model
     *
     * @var \Magento\Email\Model\Template
     */
    protected $_emailModel = null;
    
    /**
     * Options for Mage_Core_Model_Email_Template used in _sendEmailTransactional()
     *
     * @var \Magento\Framework\DataObject
     */
    protected $_emailOptions = null;

    /**
     * @var \Magento\Email\Model\TemplateFactory
     */
    protected $emailTemplateFactory;

    /**
     * @var \Magento\Framework\DataObjectFactory
     */
    protected $dataObjectFactory;

    public function __construct(
        \Magento\Framework\Model\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Email\Model\TemplateFactory $emailTemplateFactory,
        \Magento\Framework\DataObjectFactory $dataObjectFactory,
        \Magento\Framework\Model\ResourceModel\AbstractResource $resource = null,
        \Magento\Framework\Data\Collection\AbstractDb $resourceCollection = null,
        \Xtwo\Buyerprotect\Helper\Data $helper,
        array $data = []
    ) {
        $this->dataObjectFactory = $dataObjectFactory;
        $this->emailTemplateFactory = $emailTemplateFactory;
        $this->_helper = $helper;
        parent::__construct(
            $context,
            $registry,
            $resource,
            $resourceCollection,
            $data
        );
    }


    /**
     * Options for Mage_Core_Model_Email_Template
     *
     * @param \Magento\Framework\DataObject $options options $_emailModel works with
     *
     * @return void
     */
    protected function _prepareEmail($options)
    {
        if (!($mailTemplate = $this->_emailModel)) {
          
            $mailTemplate = $this->emailTemplateFactory->create();

            $this->_emailModel = $mailTemplate;
        }

        $mailTemplate->setDesignConfig(array('area' => 'frontend'));
        $this->_emailOptions = $options;

        return;
    }

    /**
     * Parses email template and send it with
     * Mage_Core_Model_Email_Template::sendTransactional().
     * Resets $this->_emailOptions after send.
     *
     * @return void
     * @throw \Exception
     */
    protected function _sendTransactional()
    {
        /* @var $options Varien_Object */
        $options = $this->_emailOptions;
        /* @var $mailTemplate Mage_Core_Model_Email_Template */
        $mailTemplate = $this->_emailModel;

        if (!$options || !$mailTemplate) {
            throw Mage::exception('Xtwo_Buyerprotect', 'Email options/model is not set!');
        }

        $mailTemplate->sendTransactional(
            $options->getTemplate(),
            $options->getSender(),
            $options->getRecipient(),
            null,
            $options->getPostObject()
        );

        if (!$mailTemplate->getSentSuccess()) {
            throw Mage::exception('Xtwo_Buyerprotect', 'Email couldn\'t get sent!');
        }

        $this->_emailOptions = null;

        return;
    }      

    /**
     * Method to send the  TS SOAP data via email if SOAP itself failed. The index
     * of the param array should follow the Varien_Object format!
     *
     * Data keys of param:
     *
     * returnValue: return_value
     * tsId: ts_id
     * tsProductId: ts_product_id
     * amount: amount
     * currency: currency
     * paymentType: payment_type
     * buyerEmail: buyer_email
     * shopCustomerID: shop_customer_id
     * shopOrderID: shop_order_id
     * orderDate: order_date
     * wsUser: ws_user
     * wsPassword: ws_password
     *
     * @param array $tsSoapData data which should be transmitted with SOAP
     *
     * @return void
     * 
     */
    public static function sendTsEmailOnSoapFail($tsSoapData)
    {
        $buyerprotectionModel = new self;
        $helper = $this->_helper;
        $storeConfigPaths = array(
            'is_active' => \Xtwo\Buyerprotect\Helper::XML_PATH_TS_BUYERPROTECT_IS_ACTIVE,
            'template' => \Xtwo\Buyerprotect\Helper::XML_PATH_TS_BUYERPROTECT_ERROR_EMAIL_TEMPLATE,
            'sender' => \Xtwo\Buyerprotect\Helper::XML_PATH_TS_BUYERPROTECT_ERROR_EMAIL_SENDER,
            'recipient' => \Xtwo\Buyerprotect\Helper::XML_PATH_TS_BUYERPROTECT_ERROR_EMAIL_RECIPIENT
        );

        // not activated
        if (!$helper->isBuyerprotectActive()) {
            return;
        }

        $emailOptions = $this->dataObjectFactory->create();
        $tsSoapDataObject = $this->dataObjectFactory->create();
        $tsSoapDataObject->setData($tsSoapData);
        $options = array(
            'template' => $helper->getStoreConfig($storeConfigPaths['template']),
            'sender' => $helper->getStoreConfig($storeConfigPaths['sender']),
            'recipient' => $helper->getStoreConfig($storeConfigPaths['recipient']),
            'post_object' => array('tsSoapData' => $tsSoapDataObject)
        );
        $emailOptions->setData($options);
        $buyerprotectionModel->_prepareEmail($emailOptions);
        $buyerprotectionModel->_sendTransactional();
        return;
    }
}
