<?php 
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Buyerprotect
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Buyerprotect\Helper;
use Magento\Eav\Api\Data\AttributeGroupInterface;
use Magento\Catalog\Api\ProductAttributeGroupRepositoryInterface;

class Data extends \Magento\Framework\App\Helper\AbstractHelper
{
    /*
     * Some store config paths
     */
    const XML_PATH_TS_BUYERPROTECT = 'buyerprotection/data';
    const XML_PATH_TS_BUYERPROTECT_IS_ACTIVE = 'buyerprotection/data/active';
    const XML_PATH_TS_BUYERPROTECT_TS_ID   = 'buyerprotection/data/trustedshops_id';
    const XML_PATH_TS_BUYERPROTECT_TS_USER = 'buyerprotection/data/trustedshops_user';
    const XML_PATH_TS_BUYERPROTECT_TS_PASSWORD = 'buyerprotection/data/trustedshops_password';
    const XML_PATH_TS_BUYERPROTECT_TS_WSDL_URL = 'buyerprotection/data/trustedshops_url';
    const XML_PATH_TS_BUYERPROTECT_VARIATION = 'buyerprotection/data/variation';

    const XML_PATH_TS_AVAILABLE_PAYMENT_CODES = 'trusted_shops_payment_codes';
    const XML_PATH_TS_PAYMENT_MAPPING = 'buyerprotection/payment_mapping';

    const XML_PATH_TS_BUYERPROTECT_ERROR_EMAIL_SENDER = 'buyerprotection/data/trustedshops_erroremail_sender';
    const XML_PATH_TS_BUYERPROTECT_ERROR_EMAIL_TEMPLATE = 'buyerprotection/data/trustedshops_erroremail_template';
    const XML_PATH_TS_BUYERPROTECT_ERROR_EMAIL_RECIPIENT = 'buyerprotection/data/trustedshops_erroremail_recipient';

    const BUYERPROTECT_MODUL_NAME = 'Xtwo_Buyerprotect';
    
   

  


    /**
     * @var \Magento\Checkout\Model\Cart
     */
    protected $checkoutCart;

    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $storeManager;

    /**
     * @var \Magento\Catalog\Model\ProductFactory
     */
    protected $catalogProductFactory;

    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * @var \Magento\Framework\Registry
     */
    protected $registry;

    /**
     * @var \Magento\Framework\App\ResourceConnectionFactory
     */
    protected $resourceConnectionFactory;

    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        \Magento\Checkout\Model\Cart $checkoutCart,
       // \Magento\Checkout\Model\Session $checksesn,
        \Xtwo\Buyerprotect\Model\Session $checksesn,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Catalog\Model\ProductFactory $catalogProductFactory,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Framework\Registry $registry,
        \Magento\Framework\App\ResourceConnection $resourceConnectionFactory,
        \Magento\Eav\Model\Entity\Attribute\SetFactory $attribute_set,
        \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $productCollectionFactory,
        \Magento\Catalog\Model\ProductRepository $productRepository,
        \Magento\Catalog\Model\ProductFactory $productFactory,
        ProductAttributeGroupRepositoryInterface $productAttributeGroup,
        \Magento\Customer\Model\Session $customerSession       
    ) {
        $this->checkoutCart = $checkoutCart;
        $this->storeManager = $storeManager;
        $this->catalogProductFactory = $catalogProductFactory;
        $this->scopeConfig = $scopeConfig;
        $this->registry = $registry;
        $this->resourceConnectionFactory = $resourceConnectionFactory;
        $this->attribute_set = $attribute_set;
        $this->productCollectionFactory  = $productCollectionFactory;
        $this->productRepository = $productRepository;
        $this->productAttributeGroup = $productAttributeGroup;
        $this->checkoutSession = $checksesn;
        $this->customerSession = $customerSession;
        $this->productFactory = $productFactory;
       
        parent::__construct(
            $context
        );
    }

    public function getConfigValue() {
        return $this->scopeConfig->getValue("paymentfee/config/store_id",
        \Magento\Store\Model\ScopeInterface::SCOPE_STORE,$this->storeManager->getStore()->getStoreId());
    }

    public function validateStore(){

       $stores_c_separated = $this->getConfigValue();
       $storelist = explode(',',$stores_c_separated);
       $storeId = $this->storeManager->getStore()->getId();
      
        if(in_array($storeId,$storelist)){
          return true;
        } else {
            return false;
        }

        return false;

    }

       

    /**
     * Get custom payment mapping from system configuration.
     *
     * @return array
     */
    public function getPaymentMapping()
    {
      
        return array();
    }

    /**
     * get all buyerprotection Products in cart
     *
     * @return array
     */
    public function getTsProductsInCart()
    {
        $tsProductIds = array();
        
        /* @var $cart Mage_Checkout_Model_Cart */
        $cart = $this->checkoutCart
            ->setStore($this->storeManager->getStore());

        $quoteItems = $cart->getQuote()->getAllItems();
        if (!empty($quoteItems)) {
            $attributeSetId = $this->getDefaultAttributeSetId();
          
            foreach ($quoteItems as $quoteItem) {               
                if (!$quoteItem) continue;                
                $product = $quoteItem->getProduct(); 
                if ($product                   
                    && $product->getTypeId() == \Xtwo\Buyerprotect\Model\Type\Buyerprotect::TYPE_BUYERPROTECT) {
                    $tsProductIds[$quoteItem->getId()] = $quoteItem->getProductId();
                }
            }
        }

        return $tsProductIds;
    }

    /**
     * @return int|null
     */
    private function getDefaultAttributeSetId() {
        
        $attributeSets = $this->attribute_set->create()->getCollection();
        $attributeSets->addFieldToFilter("attribute_set_name", 'Default');
        $attributeSets->addFieldToFilter("entity_type_id", 4);       
        $attributeSet = $attributeSets->getFirstItem();
        return $attributeSet && $attributeSet->getId() ? $attributeSet->getAttributeSetId() : null;
    }

    /**
     * Gets all products of type
     *
     * if the shop has zero products of this type the function return false
     *
     * @return array|bool
     */
    public function getAllTsProductTypes()
    {
        $productCollection = $this->productCollectionFactory->create();
        $productCollection->addAttributeToSelect('*');
        $productCollection->addAttributeToFilter('type_id', 'buyerprotect');      
      
       $data = $productCollection->getData(); 

      $cnt = count($data);
       if ( $cnt <= 0) {
        return false;
       }
        $allTsProductTypes = $productCollection->getAllIds();
        return $allTsProductTypes;
    }

    /**
     * Get all payment codes defined in config.xml. These payment methods works
     * with trustedshops.de.
     *
     * @return array
     * @todo replace Mage::getStoreConfig() with $this->getStoreConfig()
     */
    public function getAvailableTsPaymentCodes()
    {
        return $this->scopeConfig->getValue(self::XML_PATH_TS_AVAILABLE_PAYMENT_CODES, \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
    }

    /**
     * Get store object.
     *
     * @return \Magento\Store\Model\Store
     */
    public function getStore()
    {
        return $this->storeManager->getStore();
    }

    /**
     * Get ISO 3 letter currency code of current store
     *
     * @return string
     */
    public function getCurrentCurrencyCode()
    {
        return $this->getCurrencyCode();
    }

    /**
     * Get ISO 3 letter currency code of current store
     *
     * @return string
     */
    public function getCurrencyCode()
    {
        return $this->getStore()->getCurrentCurrency()->getCode();
    }

    /**
     * Returns an array of required config paths for trustedshops.de SOAP Api
     *
     * @return array
     */
    public function getTsStoreConfigPaths()
    {
        $tsStoreConfigPaths = array(
            'is_active' => self::XML_PATH_TS_BUYERPROTECT_IS_ACTIVE,
            'ts_id' => self::XML_PATH_TS_BUYERPROTECT_TS_ID,
            'ws_user' => self::XML_PATH_TS_BUYERPROTECT_TS_USER,
            'ws_password' => self::XML_PATH_TS_BUYERPROTECT_TS_PASSWORD,
            'wsdl_url' => self::XML_PATH_TS_BUYERPROTECT_TS_WSDL_URL,
            'trusted_shops_payment_codes' => self::XML_PATH_TS_AVAILABLE_PAYMENT_CODES
        );

        return $tsStoreConfigPaths;
    }

    /**
     * Determine if any TS products is in cart.
     *
     * @return bool
     */
    public function hasTsProductsInCart()
    {
        return $this->customerSession->getTrustedShops() ? 1 : 0;
    }

  
    public function getTsUserId()
    {
        return $this->getStoreConfig(self::XML_PATH_TS_BUYERPROTECT_TS_ID, $this->getStore());
    }

    /**
     * retrive the current config data as array
     *
     * @return array
     */
    public function getConfigData()
    {
        return $this->getStoreConfig(self::XML_PATH_TS_BUYERPROTECT, $this->getStore());
    }
   
    public function getProduct()
    {
        return $this->registry->registry('product');
    }    
    
    public function getAttributeGroups($toJson = false)
    {
        $product = $this->getProduct();
        $setId = $product->getAttributeSetId();
        $return = array();

     
        $groupCollection = $this->productAttributeGroup->create()
            ->setAttributeSetFilter($setId)
            ->load();

        foreach ($groupCollection as $group) {
            $attributes = $product->getAttributes($group->getId(), true);

            foreach ($attributes as $key => $attribute) {
                if (!$attribute->getIsVisible()) {
                    unset($attributes[$key]);
                }
            }

            if (count($attributes) == 0) {
                continue;
            }

            $return[$group->getAttributeGroupName()] = 'group_' . $group->getId();
        }

        return $toJson ? json_encode($return) : $return;
    }

    /**
     * Get the correct app model depending on website code
     *
     * @return Mage_Core_Model_App
     */

    public function getMageApp()
    {
     
      return $storeManager = $this->storeManager;

    }

    /**
     * Get current store id of current website
     *
     * @return int
     */

    public function getStoreId()
    {
        return $this->getMageApp()->getStore()->getId();
    }

    /**
     * Get correct config values of store of current website
     *
     * @param string $path XML path
     *
     * @return mixed
     */

    public function getStoreConfig($path)
    {
        return $this->getMageApp()->getStore()->getConfig($path);
    }

    /**
     * Checks if TS Buyerprotect is activated in backend
     *
     * @return bool
     */

    public function isBuyerprotectActive()
    {
        return $this->scopeConfig->getValue(self::XML_PATH_TS_BUYERPROTECT_IS_ACTIVE,
        \Magento\Store\Model\ScopeInterface::SCOPE_STORE,$this->storeManager->getStore()->getStoreId());
    }

    /**
     * Get buyer protection variation.
     *
     * @return string [classic|excellence]
     */
    public function getVariation()
    {
        $variation = $this->scopeConfig->getValue(
            self::XML_PATH_TS_BUYERPROTECT_VARIATION
        , \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
        
        if ($variation == \Xtwo\Buyerprotect\Model\System\Config\Source\Variation::CLASSIC_VALUE) {
            return 'classic';
        }
        
        return 'excellence';
    }
    
    /**
     * JSON encoded HTML content which should be insert underneath the sku input
     * field.
     *
     * @return string
     */
    public function getTsSkuComment()
    {
        $html = '';
        $content = $this->__("Attention! Change the 'SKU' only when 'Trusted Shops' requests for this!");

        $html = '<p class="note"><span class="ts-sku-note-content"><span>'
              . $content
              . '</span></span></p>';

        return json_encode(array('content' => $html));
    }
    
    /**
     * Generate WSDL URL from 2 different options.
     *
     * @param string $type [backend|frontend] Backend or frontend webservice?
     *
     * @return string WSDL URL
     */
    public function getWsdlUrl($type = 'backend')
    {
        $mode = $this->scopeConfig->getValue(self::XML_PATH_TS_BUYERPROTECT_TS_WSDL_URL, 
        \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
        if ($type == 'frontend') {
            if ($mode == 'live') {
                $wsdl = 'https://protection';
            } else {
                $wsdl = 'https://protection-qa';
            }
            $wsdl .= '.trustedshops.com/ts/protectionservices/ApplicationRequestService?wsdl';
        } else {
            if ($mode == 'live') {
                $wsdl = 'https://www.trustedshops.de/';
            } else {
                $wsdl = 'https://qa.trustedshops.com/';
            }
            $wsdl .= 'ts/services/TsProtection?wsdl';
        }
        return $wsdl;
    }
    
 
    public function setConfigData($path, $value, $scope = 'default', $scopeId = 0, $inherit = 0)
    {
        $resource = $this->resourceConnectionFactory;
        $conn = $resource->getConnection(\Magento\Framework\App\ResourceConnection::DEFAULT_CONNECTION);
        $conn->showTableStatus($conn->getTableName('core_config_data')); // this is a fix for mysql 4.1
        $conn->query(
            'replace into ' .
            $conn->getTableName('core_config_data') .
            ' (scope, scope_id, path, value)' .
            " values ('$scope', $scopeId, '$path', '$value')"
        );
        return $this;
    }    
         
    /**
     * Get Product collection of all products with type buyerprotect
     *
     * @todo move this method to a Model class
     *
     * @return Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Collection
     */
    public function getAllTsProducts()
    {

        $productCollection = $this->productCollectionFactory->create()
        ->addAttributeToFilter('type_id', array('eq' => 'Buyerprotect')) 
     
         ->addAttributeToSelect('price')
         ->addAttributeToSelect('*');   
       
        $data = $productCollection->getData();
      
        $product = $this->productFactory->create();

       $x = array();
        foreach($data as $dt){
            $productPriceById = $product->load($dt['entity_id'])->getPrice();
        
            $x[] = $this->getProductById($dt['entity_id']);
        }
        return $x;
    }    
    
    public function getProductById($id)
    {
    
        $product = $this->productFactory->create();
        return  $product->load($id);
    }

}