<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Buyerprotect
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Buyerprotect\Helper;


class Adminhtml extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * Constants for building path to seals.
     */
    const TS_SEAL_SKIN_PATH = 'images/buyerprotect/';
    const TS_SEAL_PREFIX = 'seal_rating_';
    const TS_SEAL_DEFAULT = 'seal_rating_en';
    const TS_SEAL_SUFFIX = '.jpg';

    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $storeManager;

    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Framework\View\DesignInterface $design,
        \Magento\Store\Api\Data\StoreInterface $store,
        \Magento\Framework\View\Asset\Repository $assetRepo
    ) {
        $this->storeManager = $storeManager;
        $this->design = $design;
        $this->_store = $store;
        parent::__construct(
            $context
        );
    }


    /**
     * Determine country code according to ISO 3166-2
     *
     * http://www.iso.org/iso/country_codes/background_on_iso_3166/iso_3166-2.htm
     *
     * @param string|Mage_Core_Model_Locale $locale Locale object or represnting string.
     *
     * @see Zend_Locale
     *
     * @return string
     */
    public function getCountryCode($locale = null)
    {
        // Expecting locale format like 'en_US', 'en_UK', etc.
        if (!(is_string($locale) && (strlen($locale) == 5))) {
            if ($locale instanceof \Magento\Store\Api\Data\StoreInterface) {
                $locale = $locale->getLocaleCode();
            } else {
                $locale = $this->_store->getLocaleCode();
                // $locale = Mage::app()->getLocale()->getLocaleCode();
            }
        }

        // See Zend_Locale::_localeData
        $locale = explode('_', $locale);
        
        return strtolower($locale[1]);
    }

    /**
     * Build locale depending URL to TS seal image.
     *
     * @param array $params URL params for Mage_Core_Model_Design_Package::getSkinBaseUrl
     *
     * @return string
     */
    public function getTsSeal(array $params = array())
    {
        $sealResource = '';

    
        if ($this->storeManager->getStore()->isAdmin()) {
            $seal = self::TS_SEAL_SKIN_PATH
                . self::TS_SEAL_PREFIX
                . $this->getCountryCode()
                . self::TS_SEAL_SUFFIX;

            // Fallback to default seal, see self::TS_SEAL_DEFAULT
            if (!is_file(Mage::getDesign()->getSkinBaseDir() . DS . $seal)) {
                $seal = self::TS_SEAL_SKIN_PATH
                . self::TS_SEAL_DEFAULT
                . self::TS_SEAL_SUFFIX;
            }

          
            $sealResource = $this->assetRepo->getUrlWithParams($seal, $params);
        }

        return $sealResource;
    }
}