<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Buyerprotect
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Buyerprotect\Block;


class Widget extends \Magento\Framework\View\Element\Template
{
  
    const TRUSTEDSHOPS_URI = 'www.trustedshops.com',
          WIDGET_URI_NOSCRIPT_BADGE = 'widgets.trustedshops.com/images/badge.png',
          WIDGET_URI_PATH_JS = 'widgets.trustedshops.com/js/';
 
    const XML_PATH_SHOW_WIDGET = 'buyerprotection/data/trustedshops_certificate_logo_active';
    
   
    protected $_helper;

    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $scopeConfig;

    public function __construct(
        \Magento\Framework\View\Element\Template\Context $context,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
         \Xtwo\Buyerprotect\Helper\Data $helper,
        array $data = []
    ) {
        $this->scopeConfig = $scopeConfig;
        $this->_helper = $helper;
        parent::__construct(
            $context,
            $data
        );
    }

    
 
    protected function _getHelper()
    {
     
        return $this->_helper;
    }
    
    /**
     * Link to TS certificate page.
     * 
     * @return string
     */
    public function getCertLink()
    {
        return self::TRUSTEDSHOPS_URI . '/shop/certificate.php?shop_id=' . $this->getTsId();
    }
    
    /**
     * TS shop ID.
     * 
     * @return string
     */
    public function getTsId()
    {
        return $this->_getHelper()->getTsUserId();
    }
    
    /**
     * URI to external TS ID dependent JS which renders the widget.
     * 
     * @return string
     */
    public function getWidgetJsUri()
    {
        return self::WIDGET_URI_PATH_JS . $this->getTsId() . '.js';
    }
    
    /**
     * URI to noscript image/badge.
     * 
     * @return string
     */
    public function getWidgetNoscriptBadgeUri()
    {
        return self::WIDGET_URI_NOSCRIPT_BADGE;
    }
    
    /**
     * Render widget or not.
     * 
     * @return bool
     */
    public function isActive()
    {
       
        return $this->_getHelper()->isBuyerprotectActive() &&          
            $this->scopeConfig->getValue(self::XML_PATH_SHOW_WIDGET, \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
    }
}