<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Buyerprotect
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */


namespace Xtwo\Buyerprotect\Block\Checkout;

/** 
 * to show buyer protect forms based on condition
 * to provide buyer protect products
*/

class Form extends \Magento\Framework\View\Element\Template
{
    /**
     * @const CLASSIC_CERTIFICATE_URL URL of the form to check the seal of approval.
     */
    const CLASSIC_CERTIFICATE_URL = 'https://www.trustedshops.com/shop/certificate.php';
    
    /**
     * @const CLASSIC_SUBSCRIBE_URL URL of the form to subscribe to classic buyer protection.
     */
    const CLASSIC_SUBSCRIBE_URL = 'https://www.trustedshops.com/shop/protection.php';
    
    /**
     * @const FORM_ENCODING Encoding of subscription form.
     */
    const FORM_ENCODING = 'UTF-8';

    /**
     * @var \Magento\Tax\Helper\Data
     */
    protected $taxHelper;
        /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $_storeManager;

    public function __construct(
        \Magento\Framework\View\Element\Template\Context $context,
        \Magento\Tax\Helper\Data $taxHelper,
        \Xtwo\Buyerprotect\Helper\Data $buyerprotect,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        array $data = []
    ) {
        $this->taxHelper = $taxHelper;
        $this->buyerprotect = $buyerprotect;
        $this->_storeManager = $storeManager;
        parent::__construct(
            $context,
            $data
        );
    }

    /**
     * Check if Trusted Shops - Excellence Buyerprotection form can be shown in checkout.
     * 
     * @return boolean
     */
    public function showForm(){
        $helper = $this->buyerprotect;
        $validate_store = $helper->validateStore();
        if(!$validate_store){
           return false;
        }
        if ($helper->isBuyerprotectActive() && $helper->getAllTsProductTypes()) {
            return true;
        }
        return $helper->isBuyerprotectActive();
    }

    public function getAllTsProducts(){
       $helper = $this->buyerprotect;
       $productCollection = $helper->getAllTsProducts();
        return $productCollection;
    }
    
    /**
     * Compute tax info.
     *
     * @return string tax info
     */
    public function getTaxInfo(){
        $tax = $this->taxHelper;
        if ($tax->displayPriceIncludingTax()) {
            $taxInfo = __('Incl. tax');
        } else {
            $taxInfo = __('Excl. tax');
        }
        return $taxInfo;
    }
    
    /**
     * Get certificate validation form action URL.
     *
     * @return string
     */
    public function getCertificateAction(){
        return self::CLASSIC_CERTIFICATE_URL;
    }
    
    public function getClassicFormAction(){
        return self::CLASSIC_SUBSCRIBE_URL;
    }
    
    public function getTsId(){
        $helper = $this->buyerprotect->getTsUserId();
    }
    
    /**
     * Get current parameter encoding.
     *
     * @return string
     */
    public function getEncoding(){
        return self::FORM_ENCODING;
    }
    
    public function getPaymentType($order){               
        unset($order);
        return '';
    }

    public function getMediaUrl($path){
        return $this->_storeManager->getStore()->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA) . $path;
    }
}