<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Buyerprotect
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */


namespace Xtwo\Buyerprotect\Block\Adminhtml\System\Config;
use Magento\Widget\Block\BlockInterface;

class Documentation extends \Magento\Config\Block\System\Config\Form\Fieldset
{
    /**
     * @const TS' URL to online documentation
     */
    const ONLINE_DOC_URL = 'https://www.trustedshops.com/docs/magento/buyer_protection_%s.htm';

    /**
     * @var \Magento\Framework\Data\Form\Element\LinkFactory
     */
    protected $formElementLinkFactory;

    public function __construct(
        \Magento\Backend\Block\Context $context,
        \Magento\Backend\Model\Auth\Session $authSession,
        \Magento\Framework\View\Helper\Js $jsHelper,
        \Magento\Framework\Data\Form\Element\LinkFactory $formElementLinkFactory,
        \Magento\Framework\Locale\Resolver $locale,
        array $data = []
    ) {
        $this->formElementLinkFactory = $formElementLinkFactory;
        $this->locale = $locale;
        parent::__construct($context, $authSession, $jsHelper, $data);
    }
    /**
     * Prepare and add documentation link element.
     *
     * @param \Magento\Framework\Data\Form\Element\AbstractElement $element Form element instance
     *
     * @return string
     */
  
    public function render( \Magento\Framework\Data\Form\Element\AbstractElement $element)
    { 
        $linkText = __('Trusted Shops documentation');        
        $linkAttribs = array(
            // de, en, es, fr and pl 
            'href' => sprintf(self::ONLINE_DOC_URL, substr($this->locale->getLocale(), 0, 2)),
            'target' => '_blank',
            'value' => $linkText,
            'title' => $linkText
        );

        $element->addElement($this->formElementLinkFactory->create($linkAttribs));
        
        return parent::render($element);
    }
}