<?php 
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_B2b
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 * @author      Hemendra Ajemra
 */

namespace Xtwo\B2b\Plugin\Customer\Model;

use Magento\Store\Model\App\Emulation;
use Magento\Customer\Model\EmailNotification;
use Magento\Customer\Api\Data\CustomerInterface;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Framework\Mail\Template\TransportBuilder;
use Magento\Customer\Helper\View as CustomerViewHelper;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\Mail\Template\SenderResolverInterface;
use Magento\Store\Model\ScopeInterface;

class EmailNotificationPlugin
{
    /**#@+
     * Configuration paths for email templates and identities
     */
    const XML_PATH_CONFIRMED_EMAIL_B2B_TEMPLATE = 'customer/b2b/email_confirmed_b2b_template';

    const NEW_B2b_CONFIRM_ACCOUNT_EMAIL_REGISTERED = 'confirmed_b2b';

    const TEMPLATE_TYPES = [
        self::NEW_B2b_CONFIRM_ACCOUNT_EMAIL_REGISTERED =>self::XML_PATH_CONFIRMED_EMAIL_B2B_TEMPLATE
    ];
    /**
     * @var StoreManagerInterface
     */
    private $storeManager;

    /**
     * @var TransportBuilder
     */
    private $transportBuilder;

    /**
     * @var CustomerViewHelper
     */
    protected $customerViewHelper;
    /**
     * @var Emulation
     */
    private $emulation;
    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;
    /**
     * @var SenderResolverInterface
     */
    private $senderResolver;
    /**
     * @param StoreManagerInterface $storeManager
     * @param TransportBuilder $transportBuilder
     * @param CustomerViewHelper $customerViewHelper
     * @param Emulation|null $emulation
     */
    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        \Psr\Log\LoggerInterface $logger,
        \Xtwo\B2b\Helper\Email $emailHelper,
        StoreManagerInterface $storeManager,
        TransportBuilder $transportBuilder,
        CustomerViewHelper $customerViewHelper,
        ScopeConfigInterface $scopeConfig,
        SenderResolverInterface $senderResolver = null,
        Emulation $emulation =null
    ) {
        $this->emailHelper = $emailHelper;
        $this->logger = $logger;
        $this->storeManager = $storeManager;
        $this->transportBuilder = $transportBuilder;
        $this->customerViewHelper = $customerViewHelper;
        //$this->dataProcessor = $dataProcessor;
        $this->scopeConfig = $scopeConfig;
        $this->senderResolver = $senderResolver ?? ObjectManager::getInstance()->get(SenderResolverInterface::class);
        $this->emulation = $emulation ?? ObjectManager::getInstance()->get(Emulation::class);
    }
    /**
     * Function to change email template based on customer type
     */
    public function aroundNewAccount(
        EmailNotification $subject,
        \Closure $proceed,
        CustomerInterface $customer,
        $type = EmailNotification::NEW_ACCOUNT_EMAIL_REGISTERED,
        $backUrl = '',
        $storeId = 0,
        $sendemailStoreId = null
        )
    {
        if(($customer->getCustomAttribute('b2b_customer')) && 
            $customer->getCustomAttribute('b2b_customer')->getValue()==true){
               
                $type = self::NEW_B2b_CONFIRM_ACCOUNT_EMAIL_REGISTERED;
                $email = $customer->getEmail();
                /** @var array $from */
                $storeId=$customer->getStoreId();
                $sender = EmailNotification::XML_PATH_REGISTER_EMAIL_IDENTITY;
                $from = $this->senderResolver->resolve(
                    $this->scopeConfig->getValue($sender, ScopeInterface::SCOPE_STORE, $storeId),
                    $storeId);
                $templateId=$this->scopeConfig->getValue('customer/b2b/email_confirmed_b2b_template', 
                ScopeInterface::SCOPE_STORE, $storeId);
               
                $transport = $this->transportBuilder->setTemplateIdentifier($templateId)
                ->setTemplateOptions(['area' => 'frontend', 'store' => $storeId])
                ->setTemplateVars([])
                ->setFrom($from)
                ->addTo($email, $this->customerViewHelper->getCustomerName($customer))
                ->getTransport();
                $this->emulation->startEnvironmentEmulation($storeId, \Magento\Framework\App\Area::AREA_FRONTEND);
                $transport->sendMessage();
                $this->emulation->stopEnvironmentEmulation();
        
        }else{
            $result = $proceed($customer, $type, $backUrl, $storeId, $sendemailStoreId);
        } 
    }
}