<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_B2b
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 * @author      Hemendra Ajemra
 */

namespace Xtwo\B2b\Plugin;

use Magento\Framework\Exception\CouldNotSaveException;
use Magento\Customer\Api\CustomerRepositoryInterface as CustomerRepository;
use Magento\Customer\Api\Data\CustomerInterface;
class CreateB2bCustomer
{
    protected $_customerSession;

    public function __construct(
        \Magento\Customer\Model\Session $customerSession,
        \Magento\Customer\Api\CustomerRepositoryInterface $subject,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Customer\Api\CustomerRepositoryInterface $customerRepository,
        \Magento\Customer\Api\Data\CustomerInterface $resultOrder
        
    ) {
        $this->_customerSession = $customerSession;
        $this->scopeConfig = $scopeConfig;
        $this->storeManager = $storeManager;
        $this->customerRepository = $customerRepository;

    }
    //before
    public function afterExecute(
        \Magento\Customer\Controller\Account\CreatePost $subject,
        $result
    ) {
        $b2b_customer=$subject->getRequest()->getParam('b2b_customer_type');
        if($b2b_customer && $b2b_customer=='company'){
            //getting default group set in system
            $defaultGroupId=$this->scopeConfig->getValue(
                "customer/b2b/default_group_b2b",
                \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
                $this->storeManager->getStore()->getStoreId());
            if($this->_customerSession->getCustomer()->getId()){
                $customer = $this->customerRepository->getById($this->_customerSession->getCustomer()->getId());
                $customer->setGroupId($defaultGroupId);
                $customer->setCustomAttribute('b2b_customer', true);
                $customer->setCustomAttribute('register_as', $defaultGroupId);
                $customer->setCustomAttribute('disable_auto_group_change',1);
                $this->customerRepository->save($customer);
            }

        }
        return $result;
    }
}