<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */


namespace Xtwo\Automationshell\Ui\Component\Shelljob\Listing\Column;


use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Ui\Component\Listing\Columns\Column;
use Magento\Framework\UrlInterface;
use Magento\Backend\Model\Auth\Session;



class Actions extends Column
{
    /**
     * @var UrlInterface
     */
    protected $urlBuilder;

    /**
     * @param ContextInterface $context
     * @param UiComponentFactory $uiComponentFactory
     * @param UrlInterface $urlBuilder
     * @param array $components
     * @param array $data
     */
    public function __construct(
        ContextInterface $context,      
        UiComponentFactory $uiComponentFactory,
        UrlInterface $urlBuilder,
        \Magento\Backend\Model\Auth\Session $authSession,
        array $components = [],
        array $data = []
       
    ) {
        $this->urlBuilder = $urlBuilder;
        $this->authSession = $authSession;
        parent::__construct($context, $uiComponentFactory, $components, $data);
    }

    /**
     * Prepare Data Source
     *
     * @param array $dataSource
     * @return array
     */
    public function prepareDataSource(array $dataSource)
    {

        $username = $this->authSession->getUser()->getUsername();
        $email = $this->authSession->getUser()->getEmail();

        
      

        if (isset($dataSource['data']['items'])) {
            $storeId = $this->context->getFilterParam('store_id');

            foreach ($dataSource['data']['items'] as &$item) {

                if($email != $item['email_add'] && in_array($item['status'], array(1,2,3))){
                    if($item['status']!==1){
                        $item[$this->getData('name')]['edit'] = [
                            'href' => '#',
                            'label' => __('Edit'),
                            'hidden' => true,
                            '__disableTmpl' => true
                        ];

                    }

                } else {

                        if($item['status']!==1){
                            $item[$this->getData('name')]['edit'] = [
                                'href' => $this->urlBuilder->getUrl(
                                    'shell_cmd/index/edit',
                                    ['id' => $item['command_id'], 'store' => $storeId]
                                ),
                                'label' => __('Edit'),
                                'hidden' => false,
                                '__disableTmpl' => true
                            ];

                        }

              }  

                
            }

           
       
        }

        return $dataSource;
    }
}
