<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */
namespace Xtwo\Automationshell\Setup;

class InstallSchema implements \Magento\Framework\Setup\InstallSchemaInterface
{

	public function install(\Magento\Framework\Setup\SchemaSetupInterface $setup, \Magento\Framework\Setup\ModuleContextInterface $context)
	{
		$installer = $setup;
		$installer->startSetup();
		if (!$installer->tableExists('xtwo_shell_commands')) {
			$table = $installer->getConnection()->newTable(
				$installer->getTable('xtwo_shell_commands')
			)
				
			    ->addColumn(
					'command_id',
					\Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
					null,
					[
						'identity' => true,
						'nullable' => false,
						'primary'  => true,
						'unsigned' => true,
					],
					'Commant ID'
				)->addColumn(
					'shell_command',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					'255',
					[
						
						'nullable' => false,
						'primary'  => true,
						'unsigned' => true,
					],
					'Shell Command'
				)->addColumn(
					'code',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					255,
					['nullable => false'],
					'code'
				)
				->addColumn(
					'command_name',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					255,
					['nullable => false'],
					'Command Name'
				)
				->addColumn(
					'command_identifier',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					255,
					[],
					'Command Identifier'
				)
				->addColumn(
					'status',
					\Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
					1,
					[],
					'Command status'
				)
				->addColumn(
					'source_stores',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					'2M',
					[
                        'nullable' => true,
                    ],
					'Source store'
				)
                ->addColumn(
					'target_stores',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					'2M',
					[
                        'nullable' => true,
                    ],
					'Target store'
				)
				
                ->addColumn(
					'skus',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					'2M',
					[
                        'nullable' => true,
                    ],
					'SKUs'
				)
				->addColumn(
					'update_price_sku',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					'2M',
					[
                        'nullable' => true,
                    ],
					'update_price_sku SKUs'
				)
				->addColumn(
					'autofill_skus',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					'2M',
					[
                        'nullable' => true,
                    ],
					'autofill_skus'
				)->addColumn(
					'reset_skus',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					'2M',
					[
                        'nullable' => true,
                    ],
					'reset_skus'
				)->addColumn(
					'skus_default_image',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					'2M',
					[
                        'nullable' => true,
                    ],
					'skus_default_image'
				)->addColumn(
					'skus_value_copy',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					'2M',
					[
                        'nullable' => true,
                    ],
					'skus_value_copy'
				)->addColumn(
					'prod_optional',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					255,
					[
                        'nullable' => true,
                    ],
					'prod_optional'
				)->addColumn(
					'folderlimit',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					255,
					[
                        'nullable' => true,
                    ],
					'folderlimit'
				)->addColumn(
					'remove_all_for',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					'2M',
					[
                        'nullable' => true,
                    ],
					'remove_all_for'
				)->addColumn(
					'ignoredefaults_value_copy',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					255,
					[
                        'nullable' => true,
                    ],
					'ignoredefaults_value_copy'
				)->addColumn(
					'nooverride',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					255,
					[
                        'nullable' => true,
                    ],
					'nooverride'
				)->addColumn(
					'store_default_image',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					'2M',
					[
                        'nullable' => true,
                    ],
					'store_default_image'
				)->addColumn(
					'update_prices_store',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					'2M',
					[
                        'nullable' => true,
                    ],
					'update_prices_store'
				)->addColumn(
					'autofill_store',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					'2M',
					[
                        'nullable' => true,
                    ],
					'autofill_store'
				)->addColumn(
					'store_value_copy_target',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					'2M',
					[
                        'nullable' => true,
                    ],
					'store_value_copy_target'
				)
                ->addColumn(
					'attribute_lists',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					'2M',
					[
                        'nullable' => true,
                    ],
					'attribute_lists'
				)
                ->addColumn(
					'attribute_sets',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					'2M',
					[
                        'nullable' => true,
                    ],
					'attribute_sets'
				)->addColumn(
					'store_value_copy_source',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					'2M',
					[
                        'nullable' => true,
                    ],
					'store_value_copy_source'
				)->addColumn(
					'reset_store',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					'2M',
					[
                        'nullable' => true,
                    ],
					'reset_store'
				)->addColumn(
					'type',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					255,
					[
                        'nullable' => true,
                    ],
					'type'
				)->addColumn(
					'links',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					'2M',
					[
                        'nullable' => true,
                    ],
					'links'
				)->addColumn(
					'add_delete_info',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					255,
					[
                        'nullable' => true,
                    ],
					'add_delete_info'
				)->addColumn(
					'surcharge',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					255,
					[
                        'nullable' => true,
                    ],
					'surcharge'
				)->addColumn(
					'autofill_attributesets',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					'2M',
					[
                        'nullable' => true,
                    ],
					'autofill_attributesets'
				)->addColumn(
					'add_attribute_lists',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					'2M',
					[
                        'nullable' => true,
                    ],
					'add_attribute_lists'
				)->addColumn(
					'reset_attribute_lists',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					'2M',
					[
                        'nullable' => true,
                    ],
					'reset_attribute_lists'
				)->addColumn(
					'attribute_lists_option_copy',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					'2M',
					[
                        'nullable' => true,
                    ],
					'attribute_lists_option_copy'
				)->addColumn(
					'optional_default_image',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					'2M',
					[
                        'nullable' => true,
                    ],
					'optional_default_image'
				)
                ->addColumn(
					'email_add',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					255,
					[
                        'nullable' => true,
                    ],
					'Email address'
				)
				->addColumn(
						'created_at',
						\Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
						null,
						['nullable' => false, 'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT],
						'Created At'
				)->addColumn(
					'updated_at',
					\Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
					null,
					['nullable' => false, 'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT_UPDATE],
					'Updated At')
				->setComment('Xtwo Shell command table');
			$installer->getConnection()->createTable($table);

			$installer->getConnection()->addIndex(
				$installer->getTable('xtwo_shell_commands'),
				$setup->getIdxName(
					$installer->getTable('xtwo_shell_commands'),
					['command_name','command_identifier','source_stores'],
					\Magento\Framework\DB\Adapter\AdapterInterface::INDEX_TYPE_FULLTEXT
				),
				['command_name','command_identifier','source_stores'],
				\Magento\Framework\DB\Adapter\AdapterInterface::INDEX_TYPE_FULLTEXT
			);


			

	}
		$installer->endSetup();

		// added
		$installer1 = $setup;
		$installer1->startSetup();

		if (!$installer1->tableExists('xtwo_cron_tbl')) {
			$table1 = $installer1->getConnection()->newTable(
				$installer1->getTable('xtwo_cron_tbl')
			)
				
				->addColumn(
					'schedule_id',
					\Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
					null,
					[
						'identity' => true,
						'nullable' => false,
						'primary'  => true,
						'unsigned' => true,
					],
					'Commant ID'
				)->addColumn(
					'job_code',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					255,
					['nullable' => false],
					'job_code'
				)
				->addColumn(
					'status',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					255,
					['nullable' => true],
					'status'
				)
				->addColumn(
					'messages',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					'2M',
					['nullable' => true],
					'messages'
				)
				->addColumn(
					'created_at',
					\Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
					null,
					['nullable' => true, 'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT],
					'Created At'
			    )
				->addColumn(
					'scheduled_at',
					\Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
					null,						
					['nullable' => true, 'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT],
					'scheduled_at'
				)
				->addColumn(
					'executed_at',
					\Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
					null,
					['nullable' => true, 'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT],
					'executed_at'
				)				
				->addColumn(
					'finished_at',
					\Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,	
					null,				
					['nullable' => true, 'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT],
					'finished_at'
				)
				->addColumn(
					'mpcronschedule_email_sent',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					255,
					[
						'nullable' => true,
					],
					'mpcronschedule_email_sent'
				)		
				
				->setComment('xtwo_cron_tbl Schedule table');
			$installer1->getConnection()->createTable($table1);
	}

	$installer1->endSetup();

		// added
	}
}