<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

 
 
namespace Xtwo\Automationshell\Setup;
 
use Magento\Eav\Setup\EavSetup; 
use Magento\Eav\Setup\EavSetupFactory /* For Attribute create  */;
use Magento\Framework\Setup\InstallDataInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;

/**
 * @codeCoverageIgnore
 */

class InstallData implements InstallDataInterface
{
    /**
     * EAV setup factory
     *
     * @var EavSetupFactory
     */
    private $eavSetupFactory;
    /**
     * Init
     *
     * @param EavSetupFactory $eavSetupFactory
     */
    public function __construct(EavSetupFactory $eavSetupFactory)
    {
    $this->eavSetupFactory = $eavSetupFactory; 
    /* assign object to class global variable for use in other class methods */
    }

    /**
     * {@inheritdoc}
     * @SuppressWarnings(PHPMD.ExcessiveMethodLength)
     */
    public function install(ModuleDataSetupInterface $setup, ModuleContextInterface $context)
    {
    /** @var EavSetup $eavSetup */
    $eavSetup = $this->eavSetupFactory->create(['setup' => $setup]);

    /**
     * Add attributes to the eav/attribute
     */
    
    // $eavSetup->removeAttribute(\Magento\Catalog\Model\Product::ENTITY,'advertisement_cms_block');
   //  $eavSetup->removeAttribute(\Magento\Catalog\Model\Product::ENTITY,'advertisements_cms_block');
    // $eavSetup->removeAttribute(\Magento\Catalog\Model\Product::ENTITY,'advertisement_cms_blocks');
    $eavSetup->addAttribute(\Magento\Catalog\Model\Product::ENTITY, 'advertisement_cms_blocks', array(
        'group'                     => '_General1',
        'input'                     => 'select',
        'type'                      => 'int',
        'label'                     => 'Advertisements CMS Block',
        'source'                    => 'Xtwo\Automationshell\Model\Attribute\Source\CmsBlock',
        'global'                    => \Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface::SCOPE_GLOBAL,
        'visible'                   => 1,
        'required'                  => 0,
        'visible_on_front'          => 0,
        'is_html_allowed_on_front'  => 0,
        'is_configurable'           => 0,
        'searchable'                => 0,
        'filterable'                => 0,
        'comparable'                => 0,
        'unique'                    => false,
        'user_defined'              => false,
        'default'                   => '0',
        'is_user_defined'           => false,
        'used_in_product_listing'   => true
    ));


    $eavSetup->addAttribute(\Magento\Catalog\Model\Product::ENTITY, 'advertisement_cms_block', array(
        'group'                     => '_General1',
        'input'                     => 'select',
        'type'                      => 'int',
        'label'                     => 'Advertisements CMS Block',
        'source'                    => 'Xtwo\Automationshell\Model\Attribute\Source\CmsBlock',
        'global'                    => \Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface::SCOPE_GLOBAL,
        'visible'                   => 1,
        'required'                  => 0,
        'visible_on_front'          => 0,
        'is_html_allowed_on_front'  => 0,
        'is_configurable'           => 0,
        'searchable'                => 0,
        'filterable'                => 0,
        'comparable'                => 0,
        'unique'                    => false,
        'user_defined'              => false,
        'default'                   => '0',
        'is_user_defined'           => false,
        'used_in_product_listing'   => true
    ));



  

}

}