<?php

/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Automationshell\Model;

use Xtwo\Automationshell\Data\GridInterface;

class Grid extends \Magento\Framework\Model\AbstractModel implements GridInterface
{
    /**
     * CMS page cache tag.
     */
    const CACHE_TAG = 'xtwo_shell_commands';

    /**
     * @var string
     */
    protected $_cacheTag = 'xtwo_shell_commands';

    /**
     * Prefix of model events names.
     *
     * @var string
     */
    protected $_eventPrefix = 'xtwo_shell_commands';

    /**
     * Initialize resource model.
     */
    protected function _construct()
    {
        $this->_init(\Xtwo\Automationshell\Model\ResourceModel\Grid::class);
    }
     /**
     * Get EntityId.
     *
     * @return int
     */
    public function getCommandId()
    {
        return $this->getData(self::COMMAND_ID);
    }

    /**
     * Set EntityId.
     */
    public function setCommandId($command_id)
    {
        return $this->setData(self::COMMAND_ID, $command_id);
    }

    /**
     * Get Title.
     *
     * @return varchar
     */
    public function getCommandName()
    {
        return $this->getData(self::COMMAND_NAME);
    }

    /**
     * Set Title.
     */
    public function setCommandName($command_name)
    {
        return $this->setData(self::COMMAND_NAME, $command_name);
    }

    /**
     * Get getContent.
     *
     * @return varchar
     */
    public function getCommandIdentifier()
    {
        return $this->getData(self::COMMAND_IDENIFIER);
    }

    /**
     * Set Content.
     */
    public function setCommandIdentifier($command_identifier)
    {
        return $this->setData(self::COMMAND_IDENIFIER, $command_identifier);
    }


    public function getStatusSourceStores()
    {
        return $this->getData(self::SOURCE_STORES);
    }

    public function setSourceStores($source_stores)
    {
        return $this->setData(self::SOURCE_STORES, $source_stores);
    }

    public function getStatus()
    {
        return $this->getData(self::STATUS);
    }

    public function setStatus($status)
    {
        return $this->setData(self::STATUS, $status);
    }

    public function getTargetStores()
    {
        return $this->getData(self::TARGET_STORES);
    }

    public function setTargetStores($target_stores)
    {
        return $this->setData(self::TARGET_STORES, $target_stores);
    }

    public function getSkus()
    {
        return $this->getData(self::SKUS);
    }

    public function setSkus($skus)
    {
        return $this->setData(self::SKUS, $skus);
    }

    public function getEmailAdd()
    {
        return $this->getData(self::EMAILADD);
    }

    public function setEmailAdd($email_add)
    {
        return $this->setData(self::EMAILADD,$email_add);
    }

    public function getAttributeLists()
    {
        return $this->getData(self::ATTRIBUTELISTS);
    }

    public function setAttributeLists($attribute_lists)
    {
        return $this->setData(self::ATTRIBUTELISTS,$attribute_lists);
    }


    public function getAttributeSets()
    {
        return $this->getData(self::ATTRIBUTE_SETS);
    }

    public function setAttributeSets($attribute_sets)
    {
        return $this->setData(self::ATTRIBUTE_SETS,$attribute_sets);
    }

     // added here extra attributes for forms 

     public function getAddAttributeLists(){
        return $this->getData(self::ADD_ATTRIBUTE_SETS);
     }
   

     public function setAddAttributeLists($attribute_lists){
        return $this->setData(self::ADD_ATTRIBUTE_SETS,$attribute_sets);
     }
     
     // added here extra attributes for forms


    /**
     * Get PublishDate.
     *
     * @return varchar
     */
   

    
    /**
     * Get CreatedAt.
     *
     * @return varchar
     */
    public function getCreatedAt()
    {
        return $this->getData(self::CREATED_AT);
    }

    /**
     * Set CreatedAt.
     */
    public function setCreatedAt($createdAt)
    {
        return $this->setData(self::CREATED_AT, $createdAt);
    }

     /**
     * Get CreatedAt.
     *
     * @return varchar
     */
    public function getUpdatedAt()
    {
        return $this->getData(self::UPDATED_AT);
    }

    /**
     * Set CreatedAt.
     */
    public function setUpdatedAt($updateat)
    {
        return $this->setUpdatedAt(self::UPDATED_AT, $updateat);
    }
}
