<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Automationshell\Model;

use Magento\Framework\Shell;
use Magento\Framework\Shell\CommandRenderer;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Process\PhpExecutableFinderFactory;
// use Magento\Framework\ShellInterface;
use Symfony\Component\Process\PhpExecutableFinder;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\ResponseInterface;
// use Xtwo\Automationshell\Model\Command;
use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\Exception\FileSystemException;
use Magento\Framework\Filesystem\Directory\WriteInterface;
use Magento\Store\Model\StoreManagerInterface;
/**
 * Class Command
 * @package Xtwo\Automationshell\Model
 */
class Command
{
    /**
     * @var ShellInterface
     */
    private $shell;

    /**
     * @var PhpExecutableFinder
     */
    private $phpExecutableFinder;
    /**
     * @var StoreManagerInterface
     */
    private $storeManager;


    /**
     * Command constructor.
     *
     * @param ShellInterface $shell
     * @param PhpExecutableFinderFactory $phpExecutableFinderFactory
     */
    public function __construct(
      //  ShellInterface $shell,
        PhpExecutableFinderFactory $phpExecutableFinderFactory,
        \Magento\Framework\View\Result\PageFactory $resultPageFactory,
        \Magento\Framework\Json\Helper\Data $jsonHelper,
        \Magento\Framework\Filesystem\DirectoryList $dir,
        \Magento\Backend\Model\Auth\Session $authSession,
        \Magento\Framework\Filesystem $filesystem,
        StoreManagerInterface $storeManager,
    ) {
       // $this->shell               = $shell;
        $this->shell = new Shell(new CommandRenderer());
        $this->phpExecutableFinder = $phpExecutableFinderFactory->create();
        $this->filesystem = $filesystem;
        $this->resultPageFactory = $resultPageFactory;
        $this->jsonHelper = $jsonHelper;
        $this->dir = $dir;
        $this->authSession = $authSession;
        $this->storeManager = $storeManager;

    }

    /**
     * @param string $command
     *
     * @throws LocalizedException
     */
    public function run($command_line = ''){
     // $command_line = '';
      if(!$command_line){
         $command_line = " cache:clean";
      }

      $phpPath = $this->phpExecutableFinder->find() ?: 'php';
      $phpPath.=substr((string)phpversion(),0,3);
      $command = $phpPath." ".BP . '/bin/magento'." $command_line";  
      $varPath = $this->dir->getPath('var')."/saved_commandline";
      $exp1 = explode(':',$command_line);
      $exp2 = explode('--',$exp1[1]);
      $exp2[0] = str_replace(' ','_',trim($exp2[0]));
      $fileName = trim(strtolower($exp2[0])).".txt";
      $path = $varPath . '/' . $fileName;
      $logFile = $varPath . '/'.$fileName;

      $logFile = $this->dir->getPath('var')."/saved_commandline/$fileName";
        if(!is_dir($this->dir->getPath('var')."/saved_commandline")){
            mkdir($this->dir->getPath('var')."/saved_commandline", 0777);
            $logFile = fopen( $logFile,'a+',true);
        }

      try{
        exec($command . " > $logFile &"); 
        sleep(1);

       // $logFile =  $this->dir->getPath('var')."/saved_commandline/addattributecommand.txt";
        $logFile = $this->dir->getPath('var')."/saved_commandline/$fileName";
        if(!is_dir($this->dir->getPath('var')."/saved_commandline")){
            mkdir($this->dir->getPath('var')."/saved_commandline", 0777);
            $logFile = fopen( $logFile,'a+',true);
        }

        
         $data['message'] = file_get_contents($logFile);
        if (!$data['message']) {
            // $message = __('Command not found or error occurred.') . PHP_EOL;
            $message = 0;
        } else {
            $message = $data['message'];
        }
        //  unlink($logFile);
        return $message;
      } catch(Exception $e){

        return $e->getMessage();
      } 
      catch(DBException $e) {
         return $e->getMessage();
      }
    
    }

    public function writes(WriteInterface $writeDirectory, string $filePath,$msg)
    {
        $stream = $writeDirectory->openFile($filePath, 'w+');
        $stream->lock();
        $fileData = $msg;
        $stream->write($fileData);
        $stream->unlock();
        $stream->close();

        return true;
    }


    public function linesofcommands($pst_data){
      $cmd_text = '';
      
      $selStoreCode=[];
      
      if(array_key_exists('source_stores',$pst_data)) {
        
            if($pst_data['source_stores'] == 0){
                    $allst=$this->storeManager->getStores(true);
                    foreach($allst as $allstore){
                        $selStoreCode[]=$allstore['code'];
                    }
                    $sourceStores= implode(',',$selStoreCode);
                    
                }else{
                    $souStore=explode(',',$pst_data['source_stores']);
                
                    foreach($souStore as $souStor){
                        
                        $storeData = $this->storeManager->getStore($souStor);
                        $storeCode = (string)$storeData->getCode();
                        $selStoreCode[]=$storeCode;
                    }
                    $sourceStores= implode(',',$selStoreCode);
                }
        }
        if($pst_data['shell_command'] == 'AddAttributeCommand'){
        
            if($pst_data['attribute_lists']!='' && strpos($pst_data['attribute_lists'], 'attribute') !== false){
                $cmd_text  = "Xtwo:AddAttributeCommand ".$pst_data['attribute_lists'];
            } else {
                $cmd_text  = "Xtwo:AddAttributeCommand "." "."--attribute ".$pst_data['attribute_lists'];
            }
        } else if($pst_data['shell_command'] == 'AttributeimagedefaultCommand'){

            $temp = '';
            if($pst_data['skus'] && strpos($pst_data['skus'], 'sku') !== false){
                $temp.=' '.$pst_data['skus'];
            } else {
                $temp.=' '.' --sku '.$pst_data['skus'];
            }
            
            if(isset($pst_data['store_default_image'])){
                if($pst_data['store_default_image'] &&
                    preg_match('/\store\b/', $pst_data['store_default_image'])){
                    $temp.=' '.$pst_data['store_default_image'];
                } else {
                $temp.=' '.' --store '.$pst_data['store_default_image'];
                }
            }
            if($pst_data['optional_default_image']){
              $temp.=' '.$pst_data['optional_default_image'];
            }
            
            $cmd_text  = "Xtwo:AttributeimagedefaultCommand $temp";

        } else if($pst_data['shell_command'] == 'AttributeOptionCopyCommand'){
            $temp = '';
            $source_stores = $pst_data['source_stores'];
            //$source_stores = $pst_data['store'];
            $source_stores=$sourceStores;
            $target_stores = $pst_data['target_stores'];
            $attribute_lists = $pst_data['attribute_lists'];
            $nooverride = $pst_data['nooverride'];

            if($source_stores!='' &&  strpos($source_stores, 'src') !== false){
                $temp.=" ".$source_stores;
            } else if($source_stores!=''){
                $temp.=" ".' --src '.$source_stores;
            }

            if($target_stores!='' &&  strpos($target_stores, 'target') !== false){
                $temp.=" ".$target_stores;
            }else if($target_stores!=''){
                $temp.=" ".' --target '.$target_stores;
            }

            if($attribute_lists!='' &&  strpos($attribute_lists, 'attribute') !== false){
                $temp.=" ".$attribute_lists;
            }else if($attribute_lists!=''){
                $temp.=" ".' --attribute '.$attribute_lists;
            }

            if($nooverride!='' &&  strpos($nooverride, 'no-override') !== false){
                $temp.=" ".$nooverride;
            }else if($nooverride!=''){
                $temp.=" ".' --no-override '.$nooverride;
            }
            $cmd_text  = "Xtwo:AttributesOptionCopy $temp";

        } else if($pst_data['shell_command'] == 'AttributeresetCommand'){
     
            $temp = '';
            $skus = $pst_data['skus'];
            //$source_stores = $pst_data['source_stores'];
            $source_stores=$sourceStores;
            $attribute_lists = $pst_data['attribute_lists'];

            if($skus!='' &&  strpos($skus, 'sku') !== false){
            $temp .= ' '.$skus;
            } else if($skus!=''){
            $temp .= ' '.' --sku '.$skus;
            }

            if($source_stores != '' &&  preg_match('/\store\b/', $source_stores)){
                $temp .= ' '.$source_stores;
            } else if($source_stores != ''){
                $temp .= ' '.' --store '.$source_stores;
            }
            if($attribute_lists!='' &&  strpos($attribute_lists, 'attribute') !== false){
                $temp .= ' '.$attribute_lists;
            } else if($attribute_lists!=''){
                $temp .= ' '.' --attribute '.$attribute_lists;
            }
            
            $cmd_text  = "Xtwo:AttributeresetCommand $temp";
     
        } else if($pst_data['shell_command'] == 'AttributesAutofillsCommand'){ 
            $temp = '';
            $skus = $pst_data['skus'];
            //$store = $pst_data['store'];
            $store = $sourceStores;
            $attribute_sets = $pst_data['attribute_sets'];
            
            if($store!='' && preg_match('/\store\b/', $store)){
                $temp .= ' '.$store;
            } else if($store!=''){
                $temp .= ' '.' --store '.$store;
            }

            if($skus!='' &&  strpos($skus, 'sku') !== false){
                $skus .= ' '.$skus;
            } else if($store!=''){
                $temp .= ' '.' --sku '.$skus;
            }

            if($attribute_sets!='' &&  strpos($attribute_sets, 'attributeset') !== false){
                $attribute_sets .= ' '.$attribute_sets;
            } if($attribute_sets!=''){
                $temp .= ' '.' --attributeset '.$attribute_sets;
            }

            $cmd_text  = "Xtwo:AttributesAutofills $temp";
        } else if($pst_data['shell_command'] == 'AttributesValueCopyCommand'){
            $temp = '';
            $skus = $pst_data['skus'];
            //$source_stores = $pst_data['source_stores'];
            $source_stores=$sourceStores;
            $target_stores = $pst_data['target_stores'];
            $ignoredefaults = $pst_data['ignoredefaults'];
            
            if($skus!='' &&  strpos($skus, 'sku') !== false){
            $temp .= ' '.$skus;  
            } else if($skus!=''){
            $temp .= ' '." --sku ".$skus;  
            }

            if($source_stores !='' && preg_match('/\src\b/', $source_stores)){
            $temp .= ' '.$source_stores;  
            } else if($source_stores !=''){
            $temp .= ' '." --src ".$source_stores;  
            }

            if($target_stores !='' &&  strpos($target_stores, 'target') !== false){
            $temp .= ' '.$target_stores;  
            } else if($target_stores !=''){
            $temp .= ' '." --target ".$source_stores;  
            }

            if($ignoredefaults !='' &&  strpos($ignoredefaults , 'ignoredefaults') !== false){
            $temp .= ' '.$ignoredefaults;  
            } else if($ignoredefaults !=''){
            $temp .= ' '." --ignoredefaults  ".$source_stores;  
            }
         
            $cmd_text  = "Xtwo:AttributesValueCopyCommand $temp";
     
      }  else if($pst_data['shell_command'] == 'ImportattributeimageCommand'){
            $cmd_text = "Xtwo:attribute-option:import-attribute-image";

      } else if($pst_data['shell_command'] == 'IndexerstoreCommand'){

          $store =  "--store ytwo_xtwostore_de";
          $cmd_text = "Xtwo:IndexerstoreCommand $store";

      } else if($pst_data['shell_command'] == 'LinkedProductCommand'){
            $temp = '';
            $skus = $pst_data['skus'];
            $links = $pst_data['links'];
            $type = $pst_data['type'];

            $add_delete_info = $pst_data['add_delete_info'];

            if($add_delete_info !=''){
                $temp .= ' '.$add_delete_info;  
            }
            
            
            if($skus!='' &&  strpos($skus, 'sku') !== false){
            $temp .= ' '.$skus;  
            } else if($skus!='') {
                $temp .= ' '.' --sku '.$skus;  
            }

            if($links !='' &&  strpos($links, 'link') !== false){
            $temp .= ' '.$links;  
            } else if($links !=''){
            $temp .= ' '." --link ".$links;  
            }

            if($type !=''  &&  strpos($type, 'type') !== false){
            $temp .= ' '.$type;  
            } else if($type !=''){
                $temp .= ' '." --type ".$type;   
            }

            $cmd_text  = "Xtwo:LinkedProductCommand $temp";
      
        } else if($pst_data['shell_command'] == 'ProductimagesCommand'){
            $temp = "";
            $remove_all_for = $pst_data['remove_all_for'];
            $folderlimit = $pst_data['folderlimit'];
            $prod_optional = $pst_data['prod_optional'];   

            if($remove_all_for && strpos($remove_all_for, 'removeallfor') !== false){
                $temp = $temp." ".$remove_all_for;
            } else if($remove_all_for!=''){
            $temp = $temp." "." --removeallfor ".$remove_all_for;  
            }

            if($folderlimit && strpos($remove_all_for, 'folderlimit') !== false){
            $temp = $temp." ".$folderlimit;
            }  else if($folderlimit!='') {
            $temp = $temp." "." --folderlimit ".$folderlimit;
            }

            if($prod_optional){
            $temp = $temp." ".$prod_optional;
            }


            $cmd_text  = "Xtwo:ProductimagesCommand $temp";
            //dd($cmd_text);

        } else if($pst_data['shell_command'] == 'UpdateattributegroupsCommand'){ 
          // 
            $cmd_text  = "xtwo:catalog:update-attribute-groups-service";
        } else if($pst_data['shell_command'] == 'UpdatepricesCommand'){
            $temp = "";
            $surcharge = $pst_data['surcharge'];
          
            if($pst_data['update_prices_store']){
                $stores = $pst_data['update_prices_store'];
            }

            $skus = $pst_data['skus']; 
            
            if($surcharge!='' && strpos($surcharge, 'surcharge') !== false){
                $temp.=' '.$surcharge; 
            } else if($surcharge!='') {
                $temp.=' '."--surcharge ".$surcharge;
            }

            if(isset($stores)){
                if($stores!='' && preg_match('/\store\b/', $stores)){
                    $temp.=' '.$stores; 
                } else if($stores!=''){
                    $temp.=' '."--store ".$stores; 
                }
            }

            if($skus!=''  && strpos($skus, 'sku') !== false){
                $temp.=' '.$skus; 
            } else if($skus!=''){
                $temp.=' '."--sku ".$skus; 
            }

          $cmd_text = "Xtwo:catalog:product:prices:update --calculate $temp";

        }

      return $cmd_text;

  }

}
