<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */
        
namespace Xtwo\Automationshell\Model\Attribute\Source;

class CmsBlock extends \Magento\Eav\Model\Entity\Attribute\Source\AbstractSource
{
    /**
     * @var array
     */
    protected $options;

    /**
     * @var \Magento\Cms\Model\ResourceModel\Block\CollectionFactory
     */
    protected $cmsResourceModelBlockCollectionFactory;

    /**
     * @var \Magento\Eav\Model\ResourceModel\Entity\Attribute\OptionFactory
     */
    protected $eavResourceModelEntityAttributeOptionFactory;

    public function __construct(
        \Magento\Cms\Model\ResourceModel\Block\CollectionFactory $cmsResourceModelBlockCollectionFactory,
        \Magento\Eav\Model\ResourceModel\Entity\Attribute\OptionFactory $eavResourceModelEntityAttributeOptionFactory
    ) {
        $this->cmsResourceModelBlockCollectionFactory = $cmsResourceModelBlockCollectionFactory;
        $this->eavResourceModelEntityAttributeOptionFactory = $eavResourceModelEntityAttributeOptionFactory;
    }
    /**
     * Get all CMS blocks as options
     *
     * @param bool $withEmpty
     *
     * @return array
     */
    public function getAllOptions($withEmpty = false)
    {
        if (is_null($this->options)) {
            $this->options = array();
            $collection = $this->cmsResourceModelBlockCollectionFactory->create();
            /** @var \Magento\Cms\Model\Block $block */
            foreach ($collection as $block) {
                $label = sprintf('[%s] %s', $block->getId(), $block->getTitle());
                $this->options[] = array('label' => $label, 'value' => $block->getId());
            }
        }
        $options = $this->options;
        if ($withEmpty) {
            array_unshift($options, array('value' => '', 'label' => ''));
        }

        return $options;
    }

    /**
     * Retrieve flat column definition
     *
     * @return array
     */
    public function getFlatColums()
    {
        $attributeCode = $this->getAttribute()->getAttributeCode();
        $column = array(
            'unsigned'  => true,
            'default'   => null,
            'extra'     => null
        );

        if (Mage::helper('core')->useDbCompatibleMode()) {
            $column['type']     = 'int';
            $column['is_null']  = true;
        } else {
            $column['type']     = \Magento\Framework\Db\Ddl\Table::TYPE_INTEGER;
            $column['nullable'] = true;
            $column['comment']  = $attributeCode . ' column';
        }

        return array($attributeCode => $column);
    }

    /**
     * Retrieve Select for update attribute value in flat table
     *
     * @param   int $store
     * @return  \Magento\Framework\Db\Select|null
     */
    public function getFlatUpdateSelect($store)
    {
        return $this->eavResourceModelEntityAttributeOptionFactory->create()
                   ->getFlatUpdateSelect($this->getAttribute(), $store, false);
    }
}
