<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Automationshell\Controller\Adminhtml\Shelllog;

use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Exception\LocalizedException;
use Xtwo\Automationshell\Controller\Adminhtml\AbstractLog;
use Xtwo\Automationshell\Model\ResourceModel\Log\CollectionFactory;

use Magento\Framework\View\Result\PageFactory;




/**
 * Class MassDelete
 * @package Xtwo\Automationshell\Controller\Adminhtml\Shelllog
 */
class MassDelete extends AbstractLog
{

    public function __construct(
        \Magento\Backend\App\Action\Context $context,   
        PageFactory $resultPageFactory,
        \Magento\Ui\Component\MassAction\Filter $filter,
        CollectionFactory $collectionFactory,
        \Magento\Framework\ObjectManagerInterface $objectmanager     
    )
    { 
       $this->filter = $filter;
       $this->collectionFactory = $collectionFactory;
       $this->objectManager = $objectmanager;
        parent::__construct($context,$resultPageFactory,$filter,$collectionFactory);
    }

    /**
     * execute function
     * @param null
     * @return ResponseInterface
     * @throws LocalizedException
     */
    public function execute()
    {
        $count = 0;
        /** @var Collection $collection */
        $collection = $this->filter->getCollection($this->collectionFactory->create());

        foreach ($collection as $item) {
         
            $deleteItem = $this->_objectManager->get('Xtwo\Automationshell\Model\Log')->load($item->getId());
            $deleteItem->delete();
          
            
           $count++;
        }

     
        $this->messageManager->addSuccessMessage(__('A total of %1 record(s) have been deleted.', $count));

        return $this->_redirect('*/*/');
    }

    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Xtwo_Automationshell::shelllog');
    }

}
