<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Automationshell\Controller\Adminhtml\Shelllog;

use Magento\Framework\App\ResponseInterface;
use Xtwo\Automationshell\Controller\Adminhtml\AbstractLog;

/**
 * Class Clear
 * @package \Xtwo\Automationshell\Controller\Adminhtml\Shelllog\Clear.php
 * to clear logs
 * @param null
 * @return redirect
 */

class Clear extends AbstractLog
{
    /**
     * @return ResponseInterface
     */
    public function execute()
    {
       
        $collection = $this->collectionFactory->create();

        $count = $collection->getSize();
        $collection->getMainTable();
        
        $collection->getConnection()->truncateTable($collection->getMainTable());

        $this->messageManager->addSuccessMessage(__('A total of %1 record(s) have been deleted.', $count));

        return $this->_redirect('*/*/');
    }
}
