<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Automationshell\Controller\Adminhtml\Index;

use Xtwo\Automationshell\Model\Command;
use Magento\Backend\Model\Auth\Session;

/**
 * Saves shelljob data into database
 * execute cammand line functions
 */

class Save extends \Magento\Backend\App\Action{
    protected $_ShelljobFactory;

    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Xtwo\Automationshell\Model\ShelljobFactory $ShelljobFactory,
        \Xtwo\Automationshell\Model\LogFactory $logFactory,
        Command $command,
        \Magento\Backend\Model\Auth\Session $authSession
        
    ){
       $this->authSession = $authSession;
       $this->_logFactory = $logFactory; 
       $this->_ShelljobFactory = $ShelljobFactory;
       $this->command = $command;
       parent::__construct($context);        
    }

    /**
     * @execute command line text
     * @param null
     */
    
    public function execute()
    {
        $ldata['created_at'] = date('Y-M-d h:i:s');
        $username = $this->authSession->getUser()->getUsername();
        $email = $this->authSession->getUser()->getEmail();
        $data = $this->getRequest()->getPostValue();

        $request = $this->getRequest();
        
        $is_execute = $request->getParam('is_execute');
       
        $data['email_add'] = $email;

        if(isset($data['shell_command'])){
          //  $data['code'] = $data['shell_command'];
            $data['shell_command'] = $data['shell_command'];
        } 

        if(isset($data['skus_default_image'])){
            $data['skus'] = $data['skus_default_image'];
        } 
        else if(isset($data['reset_skus'])){
            $data['skus'] = $data['reset_skus'];
        }

        else if(isset($data['autofill_skus'])){
            $data['skus'] = $data['autofill_skus'];
        }

        else if(isset($data['skus_value_copy'])){
            $data['skus'] = $data['skus_value_copy'];
        }

        else if(isset($data['update_price_sku'])){
            $data['skus'] = $data['update_price_sku'];
        }
       
        else if(isset($data['update_prices_store'])){
            $data['store'] = $data['update_prices_store'];
        }
        

        else if(isset($data['skus'])){
            $data['skus'] = $data['skus'];
        }

        if(isset($data['attribute_lists'])){
            $data['attribute_lists'] = $data['attribute_lists'];
        } 
        else if(isset($data['add_attribute_lists'])){
            $data['attribute_lists'] = $data['add_attribute_lists'];
        } 
        else if(isset($data['attribute_lists_option_copy'])){
            $data['attribute_lists'] = $data['attribute_lists_option_copy'];
        } else if(isset($data['reset_attribute_lists'])){
            $data['attribute_lists'] = $data['reset_attribute_lists'];
        } 
        
        // autofill check

        if(isset($data['attribute_sets'])){
            $data['attribute_sets'] = $data['attribute_sets'];
        } else if(isset($data['autofill_attributesets'])){
            $data['attribute_sets'] = $data['autofill_attributesets'];
        }

        if(isset($data['source_stores'])){
           // $data['source_stores'] = $data['source_stores'];
           $data['source_stores'] = implode(',',$data['source_stores']);
        }
        if(isset($data['reset_store'])){
            $data['source_stores'] = $data['reset_store'];
        }
        if(isset($data['store_value_copy_source'])){
            $data['source_stores'] = $data['store_value_copy_source'];
        }

        if(isset($data['target_stores'])){
            $data['target_stores'] = $data['target_stores'];
        }
        if(isset($data['store_value_copy_target'])){
            $data['target_stores'] = $data['store_value_copy_target'];
        }
        // attribute copy 
        if(isset($data['store'])){
            $data['source_stores'] = $data['store'];
        }
        if(isset($data['stores'])){
            $data['stores'] = $data['stores'];
        }
        if(isset($data['autofill_store'])){
            $data['stores'] = $data['autofill_store'];
        }

        if(isset($data['update_prices_store'])){
            $data['stores'] = $data['update_prices_store'];
        }

        if(isset($data['store_default_image'])){
            $data['stores'] = $data['store_default_image'];
        }

        if(isset($data['optional_default_image'])){
            $data['optional_default_image'] = $data['optional_default_image'];
        }

        if(isset($data['nooverride'])){
            $data['nooverride'] = $data['nooverride'];
        }

        if(isset($data['ignoredefaults_value_copy'])){
            $data['ignoredefaults'] = $data['ignoredefaults_value_copy'];
        }

        if(isset($data['code'])){
            $job_code = $data['code'];
        }else{
            $job_code = $data['command_name'];
        }
        if($is_execute){
            $single_command_line =  $this->command->linesofcommands($data);
            $ldata['execute_at'] = date('Y-M-d h:i:s');
            $result = $this->command->run($single_command_line);

        } else {
            $result = 0; 
        }

        $reviewId = isset($data['command_id']) ? $data['command_id'] : '';
        if (!$data) {
            $this->_redirect('shell_cmd/index/index');
        }
        try {
           
            $rowData = $this->_ShelljobFactory->create()->load($reviewId);
            
            $logdata = $this->_logFactory->create()->load($job_code,'job_code');

            if (!$rowData->getCommandId() && $reviewId) {
                $this->messageManager->addError(__('row data no longer exist.'));
                $this->_redirect('shell_cmd/index/index');
            }
            
            // $data['status'] = 2; 
            if(!empty($result) && $result!='' && strlen($result) > 20 ){
                $error_add = "( Shell CMD Success )";
                $data['status'] = 1;
            } else if(!empty($result) && $result!='' && strlen($result) < 20 ){
                $error_add = '( Shell command failed )';
                $data['status'] = 4;
            } else if($result == 0){
                $error_add = '';
                $data['status'] = 3;
                
            } else {
                $data['status'] = 2;
            }

            $ldata['finished_at'] = date('Y-M-d h:i:s');

            $ldata['job_code'] = $data['command_name'];
            $ldata['messages'] = $result;
            $ldata['status'] = $data['status'];
            $ldata['mpcronschedule_email_Sent'] = '';

            $rowData->setData($data);
            $rowData->save();

            $logdata->setData($ldata);
            $logdata->save();
            
            $this->messageManager->addSuccess(__('Row data has been successfully saved.'.$error_add));
        } catch (\Exception $e) {
            $this->messageManager->addError(__($e->getMessage()));
        }
        $this->_redirect('shell_cmd/index/index');
    }

    /**
     * prepare command line text
     * @param postdata
     * @return text 
     * 
     */
    public function linesofcommands1($pst_data){
        $cmd_text = '';
      
        if($pst_data['shell_command'] == 'AddAttributeCommand'){    
            
            if($pst_data['attribute_lists']!='' && strpos($pst_data['attribute_lists'], 'attribute') !== false){
              $cmd_text  = "Xtwo:AddAttributeCommand ".$pst_data['attribute_lists'];
            } else {
              $cmd_text  = "Xtwo:AddAttributeCommand "." "."--attribute ".$pst_data['attribute_lists'];
            }  

        } else if($pst_data['shell_command'] == 'AttributeimagedefaultCommand'){ 
            $temp = '';
            
            if($pst_data['skus'] && strpos($pst_data['skus'], 'sku') !== false){
                $temp.=' '.$pst_data['skus'];
            } else {
                $temp.=' '.' --sku '.$pst_data['skus'];
            }

            if($pst_data['stores'] && strpos($pst_data['stores'], 'store') !== false){
                $temp.=' '.$pst_data['stores'];
            } else {
                $temp.=' '.' --store '.$pst_data['stores'];
            }

            if($pst_data['optional_default_image']){
                $temp.=' '.$pst_data['optional_default_image'];
            }
            $cmd_text  = "Xtwo:AttributeimagedefaultCommand $temp";            
        } else if($pst_data['shell_command'] == 'AttributeOptionCopyCommand'){ 
            $temp = '';
            $source_stores = $pst_data['source_stores'];

            $target_stores = $pst_data['target_stores'];
            $attribute_lists = $pst_data['attribute_lists'];
            $nooverride = $pst_data['nooverride'];

            if($source_stores!='' &&  strpos($source_stores, 'src') !== false){
                $temp.=" ".$source_stores;
            } else if($source_stores!=''){
                $temp.=" ".' --src '.$source_stores;
            }

            if($target_stores!='' &&  strpos($target_stores, 'target') !== false){
                $temp.=" ".$target_stores;
            }else if($target_stores!=''){
                $temp.=" ".' --target '.$target_stores;
            }

            if($attribute_lists!='' &&  strpos($attribute_lists, 'attribute') !== false){
                 $temp.=" ".$attribute_lists;
            }else if($attribute_lists!=''){
                $temp.=" ".' --attribute '.$attribute_lists;
            }

            if($nooverride!='' &&  strpos($nooverride, 'no-override') !== false){
                $temp.=" ".$nooverride;
            }else if($nooverride!=''){
                $temp.=" ".' --no-override '.$nooverride;
            }
            $cmd_text  = "Xtwo:AttributesOptionCopy $temp";

        } else if($pst_data['shell_command'] == 'AttributeresetCommand'){
           $temp = '';
           $skus = $pst_data['skus'];
           $source_stores = $pst_data['source_stores'];
           $attribute_lists = $pst_data['attribute_lists'];

           if($skus!='' &&  strpos($skus, 'sku') !== false){
            $temp .= ' '.$skus;
           } else if($skus!=''){
            $temp .= ' '.' --sku '.$skus;
          }
           if($source_stores != '' &&  preg_match('/\store\b/', $source_stores)){
            $temp .= ' '.$source_stores;
           } else if($source_stores != ''){
              $temp .= ' '.' --store '.$source_stores;
           }

           if($attribute_lists!='' &&  strpos($attribute_lists, 'attribute') !== false){
            $temp .= ' '.$attribute_lists;
           } else if($attribute_lists!=''){
            $temp .= ' '.' --attribute '.$attribute_lists;
            }

           $cmd_text  = "Xtwo:AttributeresetCommand $temp";
       
        } else if($pst_data['shell_command'] == 'AttributesAutofillsCommand'){ 
             
            $temp = '';
            $skus = $pst_data['skus'];
            $store = $pst_data['store'];
            $attribute_sets = $pst_data['attribute_sets'];

            if($store!='' && preg_match('/\store\b/', $store)){
                $temp .= ' '.$store;
            } else if($store!=''){
                $temp .= ' '.' --store '.$store;
            }

            if($skus!='' &&  strpos($skus, 'sku') !== false){
                $skus .= ' '.$skus;
            } else if($store!=''){
                $temp .= ' '.' --sku '.$skus;
            }

            if($attribute_sets!='' &&  strpos($attribute_sets, 'attributeset') !== false){
                $attribute_sets .= ' '.$attribute_sets;
            } if($attribute_sets!=''){
                $attribute_sets .= ' '.' --attributeset '.$attribute_sets;
            }

            $cmd_text  = "Xtwo:AttributesAutofills $temp";
        
        } else if($pst_data['shell_command'] == 'AttributesValueCopyCommand'){ 
            
          $temp = '';
           $skus = $pst_data['skus'];
           $source_stores = $pst_data['source_stores'];
           $target_stores = $pst_data['target_stores'];
           $ignoredefaults = $pst_data['ignoredefaults'];
           
           if($skus!='' &&  strpos($skus, 'sku') !== false){
            $temp .= ' '.$skus;  
           } else if($skus!=''){
            $temp .= ' '." --sku ".$skus;  
           }

           if($source_stores !='' && preg_match('/\src\b/', $source_stores)){
            $temp .= ' '.$source_stores;  
           } else if($source_stores !=''){
            $temp .= ' '." --src ".$source_stores;  
           }

           if($target_stores !='' &&  strpos($target_stores, 'target') !== false){
            $temp .= ' '.$target_stores;  
           } else if($target_stores !=''){
            $temp .= ' '." --target ".$source_stores;  
           }

           if($ignoredefaults !='' &&  strpos($ignoredefaults , 'ignoredefaults') !== false){
            $temp .= ' '.$ignoredefaults;  
           } else if($ignoredefaults !=''){
            $temp .= ' '." --ignoredefaults  ".$source_stores;  
           }
           
           $cmd_text  = "Xtwo:AttributesValueCopyCommand $temp";
       
        }  else if($pst_data['shell_command'] == 'ImportattributeimageCommand'){ 
            $cmd_text = "Xtwo:attribute-option:import-attribute-image";
        } else if($pst_data['shell_command'] == 'IndexerstoreCommand'){
            $store =  "--store ytwo_xtwostore_de";
            $cmd_text = "Xtwo:IndexerstoreCommand $store";
        } else if($pst_data['shell_command'] == 'LinkedProductCommand'){ 
            $temp = '';
            $skus = $pst_data['skus'];
            $links = $pst_data['links'];
            $type = $pst_data['type'];

            $add_delete_info = $pst_data['add_delete_info'];

            if($add_delete_info !=''){
                $temp .= ' '.$add_delete_info;  
              }
            
            if($skus!='' &&  strpos($skus, 'sku') !== false){
             $temp .= ' '.$skus;  
            } else if($skus!='') {
                $temp .= ' '.' --sku '.$skus;  
            }
 
            if($links !='' &&  strpos($links, 'link') !== false){
             $temp .= ' '.$links;  
            } else if($links !=''){
              $temp .= ' '." --link ".$links;  
            }
 
            if($type !=''  &&  strpos($type, 'type') !== false){
             $temp .= ' '.$type;  
            } else if($type !=''){
                $temp .= ' '." --type ".$type;   
            }

            $cmd_text  = "Xtwo:LinkedProductCommand $temp";
        
        } else if($pst_data['shell_command'] == 'ProductimagesCommand'){ 
           $temp = "";
           
           $remove_all_for = $pst_data['remove_all_for'];
           $folderlimit = $pst_data['folderlimit'];
           $prod_optional = $pst_data['prod_optional'];   

           if($remove_all_for && strpos($remove_all_for, 'removeallfor') !== false){
               $temp = $temp." ".$remove_all_for;
           } else if($remove_all_for!=''){
            $temp = $temp." "." --removeallfor ".$remove_all_for;  
           }

           if($folderlimit && strpos($remove_all_for, 'folderlimit') !== false){
            $temp = $temp." ".$folderlimit;
           }  else if($folderlimit!='') {
            $temp = $temp." "." --folderlimit ".$folderlimit;
           }

           if($prod_optional){
            $temp = $temp." ".$prod_optional;
           }

           $cmd_text  = "Xtwo:ProductimagesCommand $temp";

        } else if($pst_data['shell_command'] == 'UpdateattributegroupsCommand'){ 
            // 
            $cmd_text  = "xtwo:catalog:update-attribute-groups-service";
        } else if($pst_data['shell_command'] == 'UpdatepricesCommand'){ 
            // Xtwo:catalog:product:prices:update --calculate --surcharge 9.90 --store xtwostorede
            $temp = "";
           
            $surcharge = $pst_data['surcharge'];
            $stores = $pst_data['stores'];
            $skus = $pst_data['skus']; 
            
            if($surcharge!='' && strpos($surcharge, 'surcharge') !== false){
                $temp.=' '.$surcharge; 
            } else if($surcharge!='') {
                $temp.=' '."-- surcharge ".$surcharge;
            }

            if($stores!='' && preg_match('/\store\b/', $stores)){
                $temp.=' '.$stores; 
            } else if($stores!=''){
                $temp.=' '."-- store ".$stores; 
            }

            if($skus!=''  && strpos($skus, 'sku') !== false){
                $temp.=' '.$skus; 
            } else if($skus!=''){
                $temp.=' '."-- sku ".$skus; 
            }

            $cmd_text = "Xtwo:catalog:product:prices:update --calculate $temp";
        }
        return $cmd_text;

    }
    /**
     * @return bool
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Xtwo_Automationshell::home');
    }
}