<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Automationshell\Controller\Adminhtml\Index;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Exception\LocalizedException;
use Xtwo\Automationshell\Model\Command;

use Xtwo\Automationshell\Model\ResourceModel\Shelljob\CollectionFactory;



/**
 * Class Run
 * may or may not be needed, used any where
 * @package Xtwo\Automationshell\Controller\Adminhtml\Shelljob
 */

class Run extends Action
{
    /**
     * @var Command
     */
    private $command;

    /**
     * Run constructor.
     *
     * @param Context $context
     * @param Command $command
     */
    public function __construct(
        Context $context,
        Command $command,
        CollectionFactory $collectionFactory
    ) {
        $this->command = $command;
        $this->collectionFactory = $collectionFactory;

        parent::__construct($context);
        
    }

    /** 
     * runs shell jobs
     * @returnredirect
     */
    public function execute()
    {
        try {
         
            $collection = $this->collectionFactory->create()->getData();


            if (!empty($collection)) {
                foreach ($collection as $data) {
                    $single_command_line =  $this->command->linesofcommands($data);
          
       
                    $result = $this->command->run($single_command_line);
                }
            }
          
            $this->messageManager->addSuccessMessage(__('All Commands have been run.'));
        } catch (LocalizedException $e) {
            $this->messageManager->addErrorMessage($e->getMessage());
        }

        return $this->_redirect('*/*/');
    }
}