<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Automationshell\Controller\Adminhtml\Index;

use Magento\Framework\App\ResponseInterface;
use Xtwo\Automationshell\Controller\Adminhtml\AbstractJob;

use Magento\Framework\Controller\ResultFactory;
use Magento\Backend\App\Action\Context;
use Magento\Ui\Component\MassAction\Filter;
use Xtwo\Automationshell\Model\ResourceModel\Grid\CollectionFactory;
use Xtwo\Automationshell\Model\Command;


/**
 * mass execute
 * 
 */

class MassExecute extends \Magento\Backend\App\Action
{

    public function __construct(
        Context $context,
        Filter $filter,
        CollectionFactory $collectionFactory,
        Command $command,
        \Xtwo\Automationshell\Model\ShelljobFactory $ShelljobFactory
    )
    {
        $this->filter = $filter;
        $this->collectionFactory = $collectionFactory;
        $this->command = $command;
        $this->_ShelljobFactory = $ShelljobFactory;
        parent::__construct($context);
    }

    /**
     * @return excecute function
     * @param null
     * @return redirect
     */
    public function execute()
    {
        $data = $this->getRequest()->getParams();

        $collection = $this->filter->getCollection($this->collectionFactory->create());
        $collectionSize = $collection->getSize();
        $result = 0;
        $error_add = '';
        foreach ($collection as $item) {

            $data = $item->getData();
            
            if ($data['status'] == 3) {
                $rowData = $this->_ShelljobFactory->create()->load($data['command_id']);
                $single_command_line = $this->command->linesofcommands($data);

                $result = $this->command->run($single_command_line);
                if (!empty($result) && $result != '' && strlen($result) > 20) {
                    $error_add = "( Shell CMD Success )";
                    $data['status'] = 1;
                } else if (!empty($result) && $result != '' && strlen($result) < 20) {
                    $error_add = '( Shell command failed )';
                    $data['status'] = 4;
                } else if ($result == 0) {
                    $error_add = '';
                    $data['status'] = 3;
                }

                $rowData->setData($data);
                $rowData->save();
            }
        }

        //$rowData = $this->_ShelljobFactory->create()->load($reviewId);
        /*if(!empty($result) && $result!='' && strlen($result) > 20 ){
        $error_add = "( Shell CMD Success )";
        $data['status'] = 1;
        } else if(!empty($result) && $result!='' && strlen($result) < 20 ){
        $error_add = '( Shell command failed )';
        $data['status'] = 4;
        } else if($result == 0){
        $error_add = '';
        $data['status'] = 3;
        }*/

        //$rowData->setData($data);
        if (empty($error_add)) {
            $this->messageManager->addWarning(__('There is no command which was pending to execute.'));
        } else {
            $this->messageManager->addSuccess(__('Row data has been successfully executed.' . $error_add));
        }


        return $this->_redirect('*/*/');



        $result = ['success' => 0, 'failure' => 0];

        foreach ($this->getSelectedRecords($data) as $name) {
            $this->executeJob($this->helper->getJobs($name), $result);
        }

        if ($success = $result['success']) {
            $this->cacheTypeList->cleanType('config');
            $this->messageManager->addSuccessMessage(__('A total of %1 record(s) have been executed.', $success));
        }

        if ($failure = $result['failure']) {
            $this->messageManager->addErrorMessage(
                __(
                    'A total of %1 record(s) can not execute. Please check the Cron Jobs Logs for more details.',
                    $failure
                )
            );
        }

        return $this->_redirect('*/*/');
    }


}