<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Automationshell\Controller\Adminhtml\Index;
use Magento\Ui\Component\MassAction\Filter;
use Xtwo\Automationshell\Model\ResourceModel\Grid\CollectionFactory;

/** 
 * MassDelete function 
 * 
*/

class MassDelete extends \Magento\Backend\App\Action
{

    protected $_ShelljobFactory;

    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Xtwo\Automationshell\Model\ShelljobFactory $ShelljobFactory,
        \Magento\Ui\Component\MassAction\Filter $filter,
        CollectionFactory $collectionFactory
        
    )
    {


       $this->_ShelljobFactory = $ShelljobFactory;

       $this->filter = $filter;
       $this->collectionFactory = $collectionFactory;
        parent::__construct($context);
    }
    public function execute()
    {
        $data = $this->getRequest()->getPostValue();
        $collection = $this->filter->getCollection($this->collectionFactory->create());

       
        try {
            foreach ($collection as $item) {
                $item->delete();
            }
            $this->messageManager->addSuccess(__('Row data has been successfully deleted.'));
        } catch (\Exception $e) {
            $this->messageManager->addError(__($e->getMessage()));
        }
        $this->_redirect('shell_cmd/index/index');
    }

    /**
     * @authorisation
     * return allowed | bool
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Xtwo_Automationshell::home');
    }
}
