<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Automationshell\Console;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Filesystem\Exception\FileNotFoundException;

use Magento\Store\Model\Store;
use Magetop\Smtp\Helper\Data as SmtpData;
use Magetop\Smtp\Mail\Rse\Mail;
use Magento\Email\Model\Template\SenderResolver;

/**
 * Command for executing cron jobs
 */

class ProductimagesCommand extends command
{
    const LIMIT_PER_CHUNK = 5000;
    const LIMIT_ROUND = 80;

    /** @var Mage_Log_Model_Log */
    protected $_log;
    /** @var \Magento\Eav\Model\Entity\Attribute\AbstractAttribute $_priceAttribute */
    protected $_priceAttribute;
    protected $_lastEntityId = 0;
    /** @var array container for result */
    protected $_processingInfoData = array();
    protected $_cleanupTrackingFolders = null;
    protected $_galleryImageCache = array();
    protected $_productImageCache = array();

    /**
     * @var \Psr\Log\LoggerInterface
     */
    protected $logger;

    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $storeManager;

    /**
     * @var 
     */
    

    public function __construct(
        \Magento\Eav\Model\Config $eavConfig,
        \Magento\Framework\Filesystem\DirectoryList $dir,
        \Magento\Catalog\Model\ResourceModel\Product $productResource, 
        \Psr\Log\LoggerInterface $logger,
        \Magento\Framework\App\State $state,
        \Magento\Eav\Model\ResourceModel\Entity\Attribute\Set\Collection $attributesetCollection,
        \Magento\Store\Model\Store $store,
        \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $productCollection,
        \Magento\Catalog\Model\ProductFactory $product,
        \Magento\Catalog\Model\Product $mproduct,
        \Magento\Framework\App\ResourceConnection $resourceConnection,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Catalog\Api\ProductRepositoryInterface $productRepository,
		\Magento\Framework\Translate\Inline\StateInterface $inlineTranslation,
        \Magento\Framework\Mail\Template\TransportBuilder $transportBuilder,
        Mail $mailResource,
        SenderResolver $senderResolver,
        SmtpData $smtpDataHelper,
		\Xtwo\Automationshell\Console\SendMail\Data $emaildata,									
        \Magento\Catalog\Model\Product\Gallery\Processor $processor      
    ) {
		$this->emaildata = $emaildata;							  
        $this->productRepository = $productRepository;
        $this->processor = $processor;
        $this->mproduct =  $mproduct;
        $this->resourceConnection = $resourceConnection;
        $this->eavConfig = $eavConfig;
        $this->dir = $dir;
        $this->productResource =  $productResource;      
        $this->logger = $logger;     
        $this->state = $state;
        $this->attributesetCollection = $attributesetCollection;
        $this->store = $store;
        $this->productCollection = $productCollection;       
        $this->product = $product;
        $this->connection = $this->resourceConnection->getConnection();
        $this->scopeConfig = $scopeConfig;    
        $this->storeManager = $storeManager;
		$this->smtpDataHelper    = $smtpDataHelper;

        $this->_inlineTranslation = $inlineTranslation;
        $this->_transportBuilder = $transportBuilder;
        $this->mailResource = $mailResource;
        $this->senderResolver    = $senderResolver;
        parent::__construct();
    }
	   
    protected function configure()
    {
        $this->setName('Xtwo:ProductimagesCommand')
            ->setDescription('ProductimagesCommand')         
            ->addOption('removeallfor', "removeallfor", InputOption::VALUE_OPTIONAL, "--removeallfor 65468768,45787878")
            ->addOption('simulate', "simulate", InputOption::VALUE_OPTIONAL, "--simulate Performs an overall cleanup of product images files. Removes all images which are not referenced
            in product image gallery. Use '--simulate' option for simulation.")
            ->addOption('folderlimit', "folderlimit", InputOption::VALUE_OPTIONAL, "--folderlimit Default: 2. Use 'no' for unlimited. Only valid for cleanup")
            ->addOption('move', "move", InputOption::VALUE_OPTIONAL, "--move Move image to /media/deletioncandidates instead of phyical deletion. Active by default!")
            ->addOption('real', "real", InputOption::VALUE_OPTIONAL, "--real real physical deletion of product image directly!")
            ->addOption('reset', "reset", InputOption::VALUE_OPTIONAL, "--reset Start folder-scanning from beginning (by deletion of tracking file in var/ folder)")
            ->addOption('fast', "fast", InputOption::VALUE_OPTIONAL, "--fast Should be used for development purposes only")
            ->addOption('cleanup', "cleanup", InputOption::VALUE_OPTIONAL, "--clean Should be used for development purposes only")
            ->addOption('notifyEmpty', "notifyEmpty", InputOption::VALUE_OPTIONAL, "--notifyEmpty prakash@day1tech.com");
            
            
            parent::configure();
    }

    /** @param string $msg */
    protected function log($msg) {
        $this->logger->log(100,$msg);
    }

    /** @param string $msg */
    protected function logMoved($msg) {
        $this->logger->log(100,$msg);
    }


    /**
     * Echo and log!
     * @param $msg
     * @param bool $isIntro
     * @param bool $skipLineBreak
     */
    protected function echoAndLog($msg, $isIntro=false, $skipLineBreak=false) {
        $echo = ($isIntro) ? $msg : '   '.$msg;
        $lb = $skipLineBreak ? '' : "\n";
        echo $echo.$lb;
        $this->log($echo);
    }


    public function getStorename()
    {
        return $this->scopeConfig->getValue(
            'trans_email/ident_sales/name',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    public function getStoreEmail()
    {
        return $this->scopeConfig->getValue(
            'trans_email/ident_sales/email',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }
    /**
     * Run script
     *
     */

    protected function execute(InputInterface $input, OutputInterface $output)    
    {
		$this->state->setAreaCode(\Magento\Framework\App\Area::AREA_FRONTEND);
        
        $this->_senderAddress =  $this->getStoreEmail();
        $this->_senderName =  $this->getStorename();

     $this->input = $input;

      if ($args = $this->input->getOption('cleanup')) {
            ini_set('xdebug.max_nesting_level', 1000);
            $isSimulation = !empty($this->input->getOption('simulate'));
           $isMove = empty($this->input->getOption('move')); // default!
           $isRealDelete = !empty($this->input->getOption('real'));
            $folderLimit = $this->getFolderLimit();
       

            $this->echoAndLog(sprintf('You start cleanup product images with %s folders. %s',
                $folderLimit ? ('limit of '.$folderLimit) : 'UNLIMITED',
                $isSimulation ? 'Simulated only.' : 'NO SIMULATION! Starting in 5 seconds.'));
            if (!$isSimulation) sleep(5);

            $deletionCandidates = [];
            $finallyDeleted = [];
            $finallyUnsuccessful = [];
            $folders = 0;
            $skippedAdPreviouslyProcessed = 0;
            try {
                $foldersProcessed = $this->getCleanUpTrackingFolders();
               $basePath = $this->getCleanupBasePath();
              // echo "\r\n";
                $directories = $this->getSubdirectoryList($basePath, []);
                foreach ($directories as $directory) {
                    $finallyDeletedRound = [];
                    if (in_array($directory, $foldersProcessed)) {
                        $skippedAdPreviouslyProcessed++;
                        continue;
                    }
                    if ($folderLimit !== false && $folders >= $folderLimit) {
                        $this->echoAndLog(sprintf("Folder limit reached: %s", $folderLimit));
                        break;
                    }
                   
                    // this line added by me
                    $directory = $directory."/_";
                    $filesAndFolders = glob($directory . '/*');
                  //  print_r($filesAndFolders);
                    foreach ($filesAndFolders as $filesAndFolder) {
                        // deletion candidates
                       // echo $filesAndFolder;
                        if ($this->isDeletionCandidate($filesAndFolder)) {
                            $deletionCandidates[] = $filesAndFolder;
                        }
                    }

                   // print_r($deletionCandidates);
                    $this->addCleanupTrackingFolder($directory);

                    foreach ($deletionCandidates as $id => $deletionCandidate) {
                        $result = false;
                        if ($isMove) {
                            if (!$this->input->getOption('fast')) sleep(3);
                            echo "inside ismove";
                            $result = $this->moveDeletionCandidate($deletionCandidate);
                            if ($result && is_string($result)) $this->logMoved($result);

                        } elseif ($isRealDelete) {
                            echo "inside isRealDelete";
                            if (!$this->input->getOption('fast')) sleep(1);
                            $result = unlink($deletionCandidate);

                        } else {
                            throw new \Exception('No deletion handling (simulate/move/real) specified!');
                        }

                        if ($result) {
                            $finallyDeleted[] = $deletionCandidate;
                            $finallyDeletedRound[] = $deletionCandidate;
                        } else {
                            $finallyUnsuccessful[] = $deletionCandidate;
                        }
                        unset($deletionCandidates[$id]);
                    }
                    if ($finallyDeletedRound) {
                        $this->echoAndLog(sprintf("Folder #%s deleted (%s):\n %s",
                            $folders + 1, '...' . substr($directory, strlen($directory) - 12),
                            implode("\n", $finallyDeletedRound)));
                    } else {
                        $this->echoAndLog(sprintf('No deletion on #%s: %s', $folders + 1,
                            '...' . substr($directory, strlen($directory) - 12)));
                    }
                    $folders++;
                }
                $this->echoAndLog(sprintf("Finally deleted total: %s", count($finallyDeleted)));
                $this->echoAndLog(sprintf("Skipped as previously processed: %s", $skippedAdPreviouslyProcessed));
                if ($skippedAdPreviouslyProcessed) {
                    $this->echoAndLog(sprintf('Use option "--reset" to start folder scanning from beginning.'));
                }
                $this->echoAndLog(sprintf("Unsuccessful: %s", count($finallyUnsuccessful)));

            } catch (Exception $e) {
                $this->echoAndLog(sprintf('Unexpected Exception: %s', $e->getMessage()));
            } catch (Error $e) {
                $this->echoAndLog(sprintf('Unexpected Error: %s', $e->getMessage()));
            }

        } else if ($args = $this->input->getOption('removeallfor')) {

            if (empty(trim($args))) {
                $this->echoAndLog(sprintf('You need to add product SKU\'s!'));
                return;
            }
            
            // ADMIN_STORE_ID = 0
            $this->storeManager->setCurrentStore(0);
            // Mage::app()->setCurrentStore(Mage_Core_Model_App::ADMIN_STORE_ID);
            $skus = explode(',', $args);
            $totalCount = count($skus);
            $processedCount = 0;
            // $resource = Mage::getSingleton('core/resource');
            // $connection = $resource->getConnection('core_write');
            $connection = $this->connection;
            foreach ($skus as $sku) {
                try {

                   // $product = Mage::getModel('catalog/product');
                    $product = $this->product->create();
                    $product->load($product->getIdBySku(trim($sku)));
                    if (!$product->getId()) {
                        $this->echoAndLog(sprintf('Product not found: %s', $sku));
                        continue;
                    }
                    $attrCode = 'media_gallery';
                    /** @var \Magento\Framework\Data\Collection $gallery */
                    $gallery = $product->getData($attrCode)['images']; //$product->getMediaGalleryImages();
                    if (empty($gallery)) {
                        $this->echoAndLog(sprintf('Product has no gallery image: %s', $sku));
                        continue;
                    }
                    $mediaGalleryData = $product->getData($attrCode);
                    if (!isset($mediaGalleryData['images']) || !is_array($mediaGalleryData['images'])) {
                        $this->echoAndLog(sprintf('Invalid gallery data: %s', $sku));
                        continue;
                    }

                    $gallery = $this->resourceConnection->getTableName('catalog_product_entity_media_gallery');
                    $galleryValue = $this->resourceConnection->getTableName('catalog_product_entity_media_gallery_value');


                    $sql = <<<EOT
DELETE FROM {$gallery}
WHERE value_id IN (SELECT value_id FROM {$galleryValue} WHERE entity_id = {$product->getId()})
EOT;

					$res = $this->resourceConnection->getConnection()->query($sql);
					$removedImageCount = $res->rowCount();

                   // $removedImageCount = $connection->delete("catalog_product_entity_media_gallery",
                     //   sprintf("entity_id = '%s'", $product->getId()));

                    // remove physically
                    $removedSuccessfully = 0;
                    if ($removedImageCount > 0) {
                        foreach ($mediaGalleryData['images'] as $image) {
                            
                            // echo $pathAbs = $this->dir->getPath(''media''). '/media/catalog/product' . $image['file'];
                             $pathAbs = $this->dir->getPath('media').'/catalog/product/'.$image['file'];
                            // $pathAbs = Mage::getBaseDir() . '/media/catalog/product' . $image['file'];
                            if (file_exists($pathAbs) && unlink($pathAbs)) {
                                $removedSuccessfully++;
                            }
                        }
                    }
                    $processedCount++;
                    $this->echoAndLog(sprintf('Successfully removed %s(%s) images: %s',
                        $removedImageCount, $removedSuccessfully, $sku));

                } catch (Exception $e) {
                    $this->echoAndLog(sprintf('Processing failed for sku %s, Reason Exception: %s', $sku, $e->getMessage()));
                }

                $this->echoAndLog(sprintf('Finished %s of %s successful.', $processedCount, $totalCount), true);

            }

        } elseif ($args = $this->input->getOption('notifyEmpty')) {
            if (!$this->getProductsWithoutGalleryImageSystemConfig('active')) {
                $this->echoAndLog('Skipped as not active in configuration.');
                return;
            }

            $limit = 3000; $round = 0; $offset = 0;

            $configuredRecipients = $this->getProductsWithoutGalleryImageSystemConfig('recipients');
            $recipients = explode(',', is_string($args) ? trim($args) : $configuredRecipients);
            if (empty($recipients)) {
                $this->echoAndLog('Skipped as not notification recipients are defined, even in config.');
                return;
            }
            $filter = $this->getProductsWithoutGalleryImageFilter();
            $this->echoAndLog(sprintf('Starting with %s filters...', count($filter)));
            $products = $this->getProductsWithoutGalleryImageActive($filter, $offset, $limit);
            $prods = [];
            while (count($products)) {
                $products = $this->getProductsWithoutGalleryImageFiltered($products, $filter);
                foreach ($products as $data) {
                    $prods[$data['entity_id']] = $data['sku'].' / '.$data['name'];
                }
                $offset += $limit;
                $processedCount = count($products);
                $products = $this->getProductsWithoutGalleryImageActive($filter, $offset, $limit);
                $this->echoAndLog(sprintf('%s products matched in chunk, read %s new ones... (offset: %s)',
                    $processedCount, count($products), $offset));
            }
            if (!empty($prods)) {
                $total = count($prods);
                $chunks = array_chunk($prods, 3000);
                foreach ($chunks as $chunk) {
                    $names = $this->getProductsWithoutGalleryImageFilter(true, true);
                    $subj = sprintf('Products without any GalleryImage: %s (of total %s) %s',
                        count($chunk), $total, empty($names) ? '' : ('['.$names.']'));
                    $namesAll = $this->getProductsWithoutGalleryImageFilter(true);
                    $lines = implode("\r\n", $chunk);
                    $body = sprintf("Protocol of products without any gallery image\nFilter:\n %s\n\n%s\n\nHappy fixing!",
                        $namesAll, $lines);
                    $this->echoAndLog($subj);
                    $sender['name'] = $this->_senderName;
                    $sender['email'] = $this->_senderAddress;
                    
					$this->emaildata->sendMail($subj,$body,$recipients);
					$this->echoAndLog('Mail sent to: '.$args);
                }
            } else {
                $subj = sprintf('Products without any GalleryImage: nothing found  %s',
                    empty($names) ? '' : ('on ['.$names.']'));
               

                    $header = 'From: '.$this->_senderAddress. "\r\n" .
                    'Reply-To: '.$this->_senderAddress. "\r\n" .
                    'X-Mailer: PHP/' . phpversion();
					$this->emaildata->sendMail($subj,$body,$recipients);
            }

        } else {
            echo $this->usageHelp();
        }
    }

    public function send() {
        $mdl = (empty($this->_module) ? '' : ' (module:'.$this->_module.')');
		if (!empty($this->_subject)) {
			$subject = $this->_subject;
		} else {
        	$subject = strtoupper($this->_project).': Announcement'.$mdl;
		}
        $rec = implode(', ', $this->_emailRecipients);
        $message = '[Project] '.$this->_project."\n";
        $message .= '[Message] '.$this->_msg."\n";
        if (!empty($this->_params)) {
            foreach ($this->_params as $param) {
                $message .= print_r($param, true)."\n";
            }
        }
        /*$header = 'From: '.$this->_senderAddress. "\r\n" .
                'Reply-To: '.$this->_senderAddress. "\r\n" .
                'X-Mailer: PHP/' . phpversion();*/
        //mail($rec, $subject, $message, $header);
		$sender['name'] = $this->_senderName;
		$sender['email'] = $this->__senderAddress;
		$this->sendEmail($sender,$subject, $message,$rec,$rec,'customemail_email_template');									
    }

    protected function getProductsWithoutGalleryImageSystemConfig($option='active') {
        $value = $this->scopeConfig->getValue('products_without_images/general/'.$option, \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
        return $value;
    }

    /**
     * @param bool $namesOnly
     * @param bool $firstOnesOnly
     * @return array|string
     */
    protected function getProductsWithoutGalleryImageFilter($namesOnly=false, $firstOnesOnly=false) {
        $value = [];
		$attrSets = $this->getProductsWithoutGalleryImageSystemConfig('attributeSets');
		if(!empty($attrSets)){
			$attributeSetNames = explode(',', $this->getProductsWithoutGalleryImageSystemConfig('attributeSets'));
			$attributeSets = [];
			foreach ($attributeSetNames as $attributeSetName) {
				if ($id = $this->getAttributeSetIdFromName($attributeSetName)) {
					$attributeSets[$id] = $attributeSetName;
				} else {
					$this->echoAndLog('Not found attributeset: '.$attributeSetName);
				}
			}
		}
        if (!empty($attributeSets)) $value['attribute_set_id'] = $attributeSets;

        $furtherAttributes = ['manufacturer', 'series'];
        foreach ($furtherAttributes as $furtherAttribute) {
			$furAttrset = $this->getProductsWithoutGalleryImageSystemConfig($furtherAttribute);
			if(!empty($furAttrset)) {
				$manufacturerNames = explode(',', $this->getProductsWithoutGalleryImageSystemConfig($furtherAttribute));
				$manufacturers = [];
				
				$attribute = $this->eavConfig->getAttribute(\Magento\Catalog\Model\Product::ENTITY, $furtherAttribute);
				$options = $attribute->getSource()->getAllOptions(false);
				foreach ($manufacturerNames as $manufacturerName) {
					if (empty($manufacturerName)) continue;
					foreach ($options as $option) {
						if (strcasecmp($manufacturerName, $option['label']) === 0) {
							$manufacturers[$option['value']] = $manufacturerName;
						}
					}
				}
			}
            if (!empty($manufacturers)) $value[$furtherAttribute] = $manufacturers;
        }


        $names = [];
        foreach (array_values($value) as $item) { $names = array_merge($names, array_values($item)); }
        if ($namesOnly) {
            return $firstOnesOnly ? reset($names).'/...' : implode(',', $names);
        } else {
            return $value;
        }
    }

    protected function getProductNamesForEntityIds($ids) {
       // $resourceRead = Mage::getModel('catalog/product')->getResource();
        $resourceRead = $this->productResource;
        $nameAttr = $resourceRead->getAttribute('name');
        $ids = implode(',', $ids);
        $query = "select entity_id, value from catalog_product_entity_varchar WHERE attribute_id = {$nameAttr->getId()} AND entity_id IN ({$ids})";
        // $result = $resourceRead->getReadConnection()->fetchAssoc($query);
        $result = $resourceRead->fetchAssoc($query);
        return $result;
    }

    /**
     * Filters the given array of products by given list of attributes.
     * @param array $products
     * @param array $filter
     * @return array
     */
    protected function getProductsWithoutGalleryImageFiltered(array $products, array $filter) {
        $result = [];
        /** @var \Magento\Catalog\Model\ResourceModel\Product\Collection $prods */
        // $prods =  Mage::getModel('catalog/product');
        $prods = $this->productCollection->create();
        unset($filter['attribute_set_id']);
        $prods->addAttributeToSelect(array_merge(['name'], array_keys($filter)));
        $prods->addIdFilter(array_keys($products));
        foreach ($prods as $productId => $product) {
            $hit = true;
            foreach ($filter as $attrKey => $attrValue) {
                $allowedValues = array_keys($attrValue);
                $value = $product->getData($attrKey);
                if (!$value || !in_array($value, $allowedValues)) {
                    $hit = false; break;
                }
            }

            if ($hit) {
                $result[$productId] = $products[$productId];
                $result[$productId]['name'] = $product->getName(); // for performance reasons
            }
        }
        return $result;
    }
    
    /**
     * @param array $filter
     * @param int $offset
     * @param int $limit
     * @return array
     */
    protected function getProductsWithoutGalleryImageActive(array $filter, $offset=0, $limit=2000) {
        // $resourceRead = Mage::getModel('catalog/product')->getResource();
        $resourceRead = $this->productResource;
        $statusAttr = $resourceRead->getAttribute('status');
       /* $query = "select pe.entity_id, pe.sku from catalog_product_entity pe ".
                    "LEFT JOIN catalog_product_entity_int cpei ON pe.entity_id = cpei.entity_id ";
        
                    $query .=   "LEFT OUTER JOIN catalog_product_entity_media_gallery pg ON pg.entity_id = pe.entity_id ".
                    "WHERE pg.entity_id IS NULL AND (cpei.attribute_id = {$statusAttr->getId()} AND cpei.value = 1) ";
        */

        $query = "select pe.entity_id, pe.sku from catalog_product_entity pe ".
                    "LEFT JOIN catalog_product_entity_int cpei ON pe.entity_id = cpei.entity_id ";
        $query .= " LEFT JOIN catalog_product_entity_media_gallery_value pg_v on cpei.entity_id = pg_v.entity_id";
        $query .= " LEFT JOIN catalog_product_entity_media_gallery pg ON pg.value_id = pg_v.value_id";
        $query .= " WHERE pg_v.entity_id IS NULL AND (cpei.attribute_id = 96 AND cpei.value = 1)";
        if (array_key_exists('attribute_set_id', $filter)) {
            $ids = implode(',', array_keys($filter['attribute_set_id']));
            $query .= "AND pe.attribute_set_id in ({$ids}) ";
        }
        $query .= "LIMIT {$offset}, {$limit}";
        $this->log('Get active products: '.$query);
       // $result = $resourceRead->fetchAssoc($query);

       $result = $this->connection->fetchAssoc($query);
        return $result;
    }

    private function getAttributeSetIdFromName($attributeSetName) {
        static $attributeSetIds = array();
        if ( !isset($attributeSetIds[$attributeSetName]) ) {
            /* setEntityTypeFilter product 4*/
            /*
            $attributeSetIds[$attributeSetName] = Mage::getResourceModel('eav/entity_attribute_set_collection')
                -> setEntityTypeFilter(4)
                -> addFilter('attribute_set_name', $attributeSetName)
                -> getFirstItem() -> getId();
                */

                $attributeSetIds[$attributeSetName] = $this->attributesetCollection
                ->setEntityTypeFilter(4)
                ->addFilter('attribute_set_name', $attributeSetName)
                ->getFirstItem() -> getId();

                
        }
        return $attributeSetIds[$attributeSetName];
    }


    /**
     * @param $key
     * @param $value
     */
    protected function addStatistics($key, $value) {
        if (array_key_exists($key, $this->_processingInfoData)) {
            $current = $this->_processingInfoData[$key];
            $this->_processingInfoData[$key] = $current + (int)$value;
        } else {
            $this->_processingInfoData[$key] = (int)$value;
        }
    }

    /**
     * @param $absPath
     * @return bool
     * @throws \Exception
     */
    protected function moveDeletionCandidate($absPath) {
        $pathInfo = pathinfo($absPath);
        $image = str_replace($this->getCleanupBasePath(), '', $absPath);
        $folder = str_replace($this->getCleanupBasePath(), '', $pathInfo['dirname']);
        $targetFolder = $this->getMoveBasePath().$folder;
        if (!is_dir($targetFolder) && !mkdir($targetFolder, 0777, true)) {
            throw new \Exception('Unable to create folder: '.$targetFolder);
        }
        $targetFile = $this->getMoveBasePath().$image;

        // Check simulation
        $isSimulation = !empty($this->input->getOption('simulate'));
        if ($isSimulation) {
            $this->echoAndLog('Simulate moving file to: '.$targetFile);
            return true;
        }

        if (!rename($absPath, $targetFile)) {
            $this->log('Unable to move file: '.$targetFile);
            return false;
        }
        return $targetFile;
    }



    protected function getReadConnection() {
        return $this->connection;
       
        /*
        $resource = Mage::getSingleton('core/resource');
        $readConnection = $resource->getConnection('core_read');
        return $readConnection;
        */
    }

    protected function getWriteConnection() {
        return $this->connection;
        //$resource = Mage::getSingleton('core/resource');
        //$connection = $resource->getConnection('core_write');
        //return $connection;
    }

    /** @return int|bool */
    protected function getFolderLimit() {
        $limit = $this->input->getOption('folderlimit');
        if (empty($limit)) $limit = 2;
        if ($limit == 'no') $limit = false;
        return $limit;
    }

    /**
     * @return \Magento\Eav\Model\Entity\Attribute\AbstractAttribute
     */
    protected function getPriceAttribute() {
        if (is_null($this->_priceAttribute)) {
            $this->_priceAttribute = $this->productResource->getAttribute('price');
            // $this->_priceAttribute = Mage::getModel('catalog/product')->getResource()->getAttribute('price');
        }
        return $this->_priceAttribute;
    }


    /**
     * Returns store or error as string message.
     * @param $code
     * @return \Magento\Store\Model\Store|string
     */
    protected function getStoreByCode($code) {
        try {
            $store = $this->storeManager->getStore($code);
        } catch (Exception $e) {
            return 'invalid store';
        }
        return $store;
    }

    /**
     * Returns path to cleanup-tracking file
     * @return string
     * @throws \Exception
     */
    protected function getCleanUpTrackingFile() {
       // $file = Mage::getBaseDir().'/var/js_productimagecleanuptracking.txt';
       // $file = $this->dir->getPath('var');.'/var/js_productimagecleanuptracking.txt';
       $file = $this->dir->getPath('var').'/js_productimagecleanuptracking.txt';
        if (!file_exists($file) && false === file_put_contents($file, "")) {
            throw new \Exception('Cannot create cleanup tracking file: '.$file);
        }
        return $file;
    }

    /**
     * @return array
     * @throws \Exception
     */
    protected function getCleanUpTrackingFolders() {
        if ($this->input->getOption('reset')) {
            unlink($this->getCleanUpTrackingFile());
            $this->_cleanupTrackingFolders = null;
        }
        if (is_null($this->_cleanupTrackingFolders)) {
            $lines = explode(PHP_EOL, file_get_contents($this->getCleanUpTrackingFile()));
            $data = [];
            foreach ($lines as $line) { if (!empty($line)) $data[] = trim($line);}
            $this->_cleanupTrackingFolders = $data;
        }
        return $this->_cleanupTrackingFolders;
    }

    /**
     * @param $path
     * @throws \Exception
     */
    protected function addCleanupTrackingFolder($path) {
        $folders = $this->getCleanUpTrackingFolders();
        if (!in_array($path, $folders)) $folders[] = $path;
        $file = $this->getCleanUpTrackingFile();
        if (!file_put_contents($file, implode(PHP_EOL, $folders))) {
            throw new \Exception('Cannot create/update cleanup tracking file: '.$file);
        }
        $this->_cleanupTrackingFolders = null;
    }

    /**
     * @param $dir
     * @param $dirs
     * @return array
     */
    protected function getSubdirectoryList($dir, $dirs) {
        if (strpos($dir, 'product/cache') !== false)  return $dirs;
        $globDirs  = glob("$dir*", GLOB_ONLYDIR);
        foreach ($globDirs as $dir) {
            $subDirs = $this->getSubdirectoryList($dir.'/', $dirs);
            $dirs = array_merge($globDirs, $subDirs);
            $dirs = array_unique($dirs);
        }
        return $dirs;
    }

    protected function getCleanupBasePath() {
       //  return Mage::getBaseDir('media') . '/catalog/product/';
        return  $this->dir->getPath('media'). '/catalog/product/';
    }

    protected function getMoveBasePath() {
       return  $this->dir->getPath('media').'/deletioncandidates/';
        // return Mage::getBaseDir('media') . '/deletioncandidates/';
    }

    /**
     * Returns true if the given file is NOT referenced somewhere and is therefore a deletion candidate.
     * @param $file
     * @return bool
     */
    protected function isDeletionCandidate($file) {
        $isReferenced = false;
        $pathInfo = pathinfo($file);
       // echo $file;
       // print_r($pathInfo);
        $extension = strtolower($pathInfo['extension']);
        if (empty($extension) || is_dir($file)) {
            $isReferenced = true; // it's a folder

        } elseif (is_file($file) && in_array($extension, ['png', 'jpg', 'jpeg', 'gif'])) {
          // echo $this->getCleanupBasePath();
           // echo $pathInfo['dirname'];
            $image = str_replace($this->getCleanupBasePath(), '', $file);
          // echo $this->getCleanupBasePath()."\r\n";
           // echo $pathInfo['dirname'];
           $folder = str_replace($this->getCleanupBasePath(), '', $pathInfo['dirname']);
          // echo $folder."----".$image."\r\n";
            $isReferenced = $this->isImageFileReferenced($image, $folder.'/');
           // echo $this->getCleanupBasePath();
           // echo $pathInfo['dirname'];
         // echo $folder.'/';
         // echo $image."\r\n";

        }
        return !$isReferenced;
    }

    /**
     * @param $path
     * @param $folder
     * @return bool
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    protected function isImageFileReferenced($path, $folder) {
       //  echo $folder."----".$path."\r\n";
        // 4/_/----4/_/4.jpg

        $this->registerGalleryImagesForPath($folder);
        $this->registerProductImagesForPath($folder);
        $imageBaseName = strtolower(pathinfo($path)['basename']);
        // We lookup ALL image names
        foreach ($this->_galleryImageCache as $folder => $images) {       
            if (in_array($imageBaseName, $images)) return true;
        }
        // We lookup ALL image names
        foreach ($this->_productImageCache as $folder => $images) {
            
            if (in_array($imageBaseName, $images)) return true;
        }
        return false;
    }

    /**
     * @param $path
     * @return mixed
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    protected function registerGalleryImagesForPath($path) {
        if (!array_key_exists($path, $this->_galleryImageCache)) {
            // $coreResource = Mage::getSingleton('core/resource');
            $coreResource = $this->connection;
            $mediaGallery = $coreResource->getTableName('catalog_product_entity_media_gallery');
            $additional = $path[0] == '/' ? substr($path, 1) : '/'.$path;
            $query = "SELECT value FROM $mediaGallery WHERE (value like '$path%') OR (value like '$additional%')";
            // $values = $coreResource->getConnection('core_read')->fetchCol($query);
            $values = $coreResource->fetchCol($query);
            

            $fileNames = [];
            foreach ($values as $value) {
                $pathInfo = pathinfo($value);
                $fileNames[] = strtolower(trim($pathInfo['basename']));
            }

            $this->_galleryImageCache[$path] = $fileNames;
        }
        return $this->_galleryImageCache[$path];
    }

    /**
     * @param $path
     * @return mixed
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    protected function registerProductImagesForPath($path) {
        if (!array_key_exists($path, $this->_productImageCache)) {
            // $coreResource = Mage::getSingleton('core/resource');
            $coreResource = $this->connection;
            $mediaGallery = $coreResource->getTableName('catalog_product_entity_varchar');
            $additional = $path[0] == '/' ? substr($path, 1) : '/'.$path;
            $query = "SELECT value FROM $mediaGallery WHERE (value like '$path%') OR (value like '$additional%')";
            // $values = $coreResource->getConnection('core_read')->fetchCol($query);
            $values = $coreResource->fetchCol($query);
            $fileNames = [];
            foreach ($values as $value) {
                $pathInfo = pathinfo($value);
                $fileNames[] = strtolower(trim($pathInfo['basename']));
            }

            // print_r($fileNames);

            $this->_productImageCache[$path] = $fileNames;
        }
        return $this->_productImageCache[$path];
    }

    /**
     * Retrieve Usage Help Message
     *
     */
    public function usageHelp()
    {
        return <<<USAGE
Usage:  php bin/magento Xtwo::ProductimagesCommand --options
        php bin/magento Xtwo::ProductimagesCommand --removeallfor 65468768,45787878 
        sudo php bin/magento Xtwo:ProductimagesCommand --cleanup 1 --simulate 1
        sudo php bin/magento Xtwo:ProductimagesCommand --cleanup 1 --real 1
        sudo php bin/magento Xtwo:ProductimagesCommand --cleanup 1 --real 1 --folderlimit 4
        sudo php bin/magento Xtwo:ProductimagesCommand --cleanup 1 --move 1 --folderlimit 4
        
  removeallfor  <SKU>[,<SKU>,<SKU>...]
                Example:Testtoday
                php bin/magento Commands:ProductimagesCommand --removeallfor 65468768,45787878

  cleanup       [--simulate] [--folderlimit]
                Performs an overall cleanup of product images files. Removes all images which are not referenced
                in product image gallery. Use '--simulate' option for simulation.
                
  notifyEmpty [<email[,email,...]>]  
                Notifys given recipients for all SKU's on products without any image. On omitted recipients, the 
                configured recipients in backend will be used.  
  
  simulate      Add option to simulate a cleanup. Only valid for "cleanup".
  folderlimit   Default: 2. Use 'no' for unlimited. Only valid for "cleanup".
  move          Move image to /media/deletioncandidates instead of phyical deletion. Active by default!
  real          "real" physical deletion of product image directly!
  reset         Start folder-scanning from beginning (by deletion of tracking file in var/ folder)
  fast          Should be used for development purposes only
  

  help          This help

USAGE;
    }
}


